/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import com.twilio.video.IceServer;
import com.twilio.video.IceTransportPolicy;
import java.util.Set;

public class IceOptions {
    private final Set<IceServer> iceServers;
    private final IceTransportPolicy iceTransportPolicy;
    private final boolean abortOnIceServersTimeout;
    private final long iceServersTimeout;

    private IceOptions(Builder builder) {
        this.iceServers = builder.iceServers;
        this.iceTransportPolicy = builder.iceTransportPolicy;
        this.abortOnIceServersTimeout = builder.abortOnIceServersTimeout;
        this.iceServersTimeout = builder.iceServersTimeout;
    }

    @NonNull
    public Set<IceServer> getIceServers() {
        return this.iceServers;
    }

    @NonNull
    public IceTransportPolicy getIceTransportPolicy() {
        return this.iceTransportPolicy;
    }

    public boolean getAbortOnIceServersTimeout() {
        return this.abortOnIceServersTimeout;
    }

    IceServer[] getIceServersArray() {
        IceServer[] iceServersArray = new IceServer[]{};
        if (this.iceServers != null && this.iceServers.size() > 0) {
            iceServersArray = this.iceServers.toArray(new IceServer[this.iceServers.size()]);
        }
        return iceServersArray;
    }

    public long getIceServersTimeout() {
        return this.iceServersTimeout;
    }

    public static class Builder {
        private Set<IceServer> iceServers;
        private IceTransportPolicy iceTransportPolicy = IceTransportPolicy.ALL;
        private boolean abortOnIceServersTimeout = false;
        private long iceServersTimeout = 3000L;

        @NonNull
        public Builder iceServers(@NonNull Set<IceServer> iceServers) {
            this.iceServers = iceServers;
            return this;
        }

        @NonNull
        public Builder iceTransportPolicy(@NonNull IceTransportPolicy iceTransportPolicy) {
            this.iceTransportPolicy = iceTransportPolicy;
            return this;
        }

        @NonNull
        public Builder abortOnIceServersTimeout(boolean abortOnIceServersTimeout) {
            this.abortOnIceServersTimeout = abortOnIceServersTimeout;
            return this;
        }

        @NonNull
        public Builder iceServersTimeout(long iceServersTimeout) {
            this.iceServersTimeout = iceServersTimeout;
            return this;
        }

        @NonNull
        public IceOptions build() {
            return new IceOptions(this);
        }
    }
}

