/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import com.twilio.video.AudioSink;
import java.nio.ByteBuffer;

class AudioSinkProxy
implements AudioSink {
    private final Handler handler;
    private final HandlerThread handlerThread;
    private final AudioSink audioSink;
    private boolean isReleased = false;

    AudioSinkProxy(AudioSink audioSink) {
        this.audioSink = audioSink;
        this.handlerThread = new HandlerThread(audioSink.toString());
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
    }

    @Override
    public void renderSample(@NonNull ByteBuffer audioSample, int encoding, int sampleRate, int channels) {
        if (this.isReleased) {
            return;
        }
        this.handler.post(() -> this.audioSink.renderSample(audioSample, encoding, sampleRate, channels));
    }

    public void release() {
        this.isReleased = true;
        this.handlerThread.quit();
    }
}

