/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import com.twilio.video.AudioTrack;
import com.twilio.video.AudioTrackPublication;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.Preconditions;

public class LocalAudioTrackPublication
implements AudioTrackPublication {
    private final String sid;
    private final LocalAudioTrack localAudioTrack;

    LocalAudioTrackPublication(@NonNull String sid, @NonNull LocalAudioTrack localAudioTrack) {
        Preconditions.checkNotNull(sid, "SID must not be null");
        Preconditions.checkNotNull(localAudioTrack, "Local audio track must not be null");
        Preconditions.checkArgument(!sid.isEmpty(), "SID must not be empty");
        this.sid = sid;
        this.localAudioTrack = localAudioTrack;
    }

    @Override
    public String getTrackSid() {
        return this.sid;
    }

    @Override
    public String getTrackName() {
        return this.localAudioTrack.getName();
    }

    @Override
    public boolean isTrackEnabled() {
        return this.localAudioTrack.isEnabled();
    }

    @Override
    public AudioTrack getAudioTrack() {
        return this.localAudioTrack;
    }

    public LocalAudioTrack getLocalAudioTrack() {
        return this.localAudioTrack;
    }
}

