/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.twilio.video.AudioOptions;
import com.twilio.video.AudioTrack;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;

public class LocalAudioTrack
extends AudioTrack {
    private static final Logger logger = Logger.getLogger(LocalAudioTrack.class);
    private final MediaFactory mediaFactory;
    private long nativeLocalAudioTrackHandle;

    public static LocalAudioTrack create(@NonNull Context context, boolean enabled) {
        return LocalAudioTrack.create(context, enabled, null);
    }

    public static LocalAudioTrack create(@NonNull Context context, boolean enabled, @Nullable AudioOptions audioOptions) {
        Preconditions.checkNotNull(context);
        Preconditions.checkState(Util.permissionGranted(context, "android.permission.RECORD_AUDIO"), "RECORD_AUDIO permission must be granted to create audio track");
        Object temporaryMediaFactoryOwner = new Object();
        MediaFactory mediaFactory = MediaFactory.instance(temporaryMediaFactoryOwner, context);
        LocalAudioTrack localAudioTrack = mediaFactory.createAudioTrack(context, enabled, audioOptions);
        if (localAudioTrack == null) {
            logger.e("Failed to create local audio track");
        }
        mediaFactory.release(temporaryMediaFactoryOwner);
        return localAudioTrack;
    }

    @Override
    public synchronized boolean isEnabled() {
        if (!this.isReleased()) {
            return this.nativeIsEnabled(this.nativeLocalAudioTrackHandle);
        }
        logger.w("Local audio track is not enabled because it has been released");
        return false;
    }

    public synchronized void enable(boolean enable) {
        if (!this.isReleased()) {
            this.nativeEnable(this.nativeLocalAudioTrackHandle, enable);
        } else {
            logger.e("Cannot enable a local audio track that has been removed");
        }
    }

    public synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalAudioTrackHandle);
            this.nativeLocalAudioTrackHandle = 0L;
            this.mediaFactory.release(this);
        }
    }

    LocalAudioTrack(long nativeLocalAudioTrackHandle, String trackId, boolean enabled, Context context) {
        super(trackId, enabled);
        this.nativeLocalAudioTrackHandle = nativeLocalAudioTrackHandle;
        this.mediaFactory = MediaFactory.instance(this, context);
    }

    boolean isReleased() {
        return this.nativeLocalAudioTrackHandle == 0L;
    }

    long getNativeHandle() {
        return this.nativeLocalAudioTrackHandle;
    }

    private native boolean nativeIsEnabled(long var1);

    private native void nativeEnable(long var1, boolean var3);

    private native void nativeRelease(long var1);
}

