/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.twilio.video.ConnectOptions;
import com.twilio.video.LocalParticipant;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Participant;
import com.twilio.video.Preconditions;
import com.twilio.video.RoomState;
import com.twilio.video.StatsListener;
import com.twilio.video.StatsReport;
import com.twilio.video.TwilioException;
import com.twilio.video.Util;
import com.twilio.video.Video;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Room {
    private static final Logger logger = Logger.getLogger(Room.class);
    private long nativeRoomDelegate;
    private Context context;
    private String name;
    private String sid;
    private RoomState roomState;
    private Map<String, Participant> participantMap = new HashMap<String, Participant>();
    private LocalParticipant localParticipant;
    private final Listener listener;
    private final Handler handler;
    private final long handlerThreadId;
    private Queue<Pair<Handler, StatsListener>> statsListenersQueue;
    private ConnectOptions cachedConnectOptions;
    private MediaFactory mediaFactory;
    private final Listener roomListenerProxy = new Listener(){

        @Override
        public void onConnected(final Room room) {
            logger.d("onConnected()");
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onConnected(room);
                }
            });
        }

        @Override
        public void onConnectFailure(final Room room, final TwilioException twilioException) {
            logger.d("onConnectFailure()");
            Room.this.releaseRoom();
            Room.this.roomState = RoomState.DISCONNECTED;
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.release();
                    Room.this.listener.onConnectFailure(room, twilioException);
                }
            });
        }

        @Override
        public void onDisconnected(final Room room, final TwilioException twilioException) {
            logger.d("onDisconnected()");
            Room.this.releaseRoom();
            if (Room.this.localParticipant != null) {
                Room.this.localParticipant.release();
            }
            Room.this.roomState = RoomState.DISCONNECTED;
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.release();
                    Room.this.listener.onDisconnected(room, twilioException);
                }
            });
        }

        @Override
        public void onParticipantConnected(final Room room, final Participant participant) {
            logger.d("onParticipantConnected()");
            Room.this.participantMap.put(participant.getSid(), participant);
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onParticipantConnected(room, participant);
                }
            });
        }

        @Override
        public void onParticipantDisconnected(final Room room, final Participant participant) {
            logger.d("onParticipantDisconnected()");
            Room.this.participantMap.remove(participant.getSid());
            participant.release();
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onParticipantDisconnected(room, participant);
                }
            });
        }

        @Override
        public void onRecordingStarted(final Room room) {
            logger.d("onRecordingStarted()");
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onRecordingStarted(room);
                }
            });
        }

        @Override
        public void onRecordingStopped(final Room room) {
            logger.d("onRecordingStopped()");
            Room.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Room.this.listener.onRecordingStopped(room);
                }
            });
        }
    };
    private final StatsListener statsListenerProxy = new StatsListener(){

        @Override
        public void onStats(final List<StatsReport> statsReports) {
            final Pair statsPair = (Pair)Room.this.statsListenersQueue.poll();
            if (statsPair != null) {
                ((Handler)statsPair.first).post(new Runnable(){

                    @Override
                    public void run() {
                        ((StatsListener)statsPair.second).onStats(statsReports);
                    }
                });
            }
        }
    };

    Room(Context context, String name, Handler handler, Listener listener) {
        this.context = context;
        this.name = name;
        this.sid = "";
        this.roomState = RoomState.DISCONNECTED;
        this.listener = listener;
        this.handler = handler;
        this.handlerThreadId = handler.getLooper().getThread().getId();
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
    }

    public String getName() {
        return this.name;
    }

    public String getSid() {
        return this.sid;
    }

    public RoomState getState() {
        return this.roomState;
    }

    public boolean isRecording() {
        return this.roomState == RoomState.CONNECTED ? this.nativeIsRecording(this.nativeRoomDelegate) : false;
    }

    public List<Participant> getParticipants() {
        return new ArrayList<Participant>(this.participantMap.values());
    }

    public LocalParticipant getLocalParticipant() {
        return this.localParticipant;
    }

    public synchronized void getStats(@NonNull StatsListener statsListener) {
        if (statsListener == null) {
            throw new NullPointerException("StatsListener must not be null");
        }
        if (this.roomState == RoomState.DISCONNECTED) {
            return;
        }
        this.statsListenersQueue.offer((Pair<Handler, StatsListener>)new Pair((Object)Util.createCallbackHandler(), (Object)statsListener));
        this.nativeGetStats(this.nativeRoomDelegate);
    }

    public synchronized void disconnect() {
        if (this.roomState != RoomState.DISCONNECTED && this.nativeRoomDelegate != 0L) {
            if (this.localParticipant != null) {
                this.localParticipant.release();
            }
            this.nativeDisconnect(this.nativeRoomDelegate);
        }
    }

    void onNetworkChanged(Video.NetworkChangeEvent networkChangeEvent) {
        if (this.nativeRoomDelegate != 0L) {
            this.nativeOnNetworkChange(this.nativeRoomDelegate, networkChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(ConnectOptions connectOptions) {
        ConnectOptions.checkAudioTracksReleased(connectOptions.getAudioTracks());
        ConnectOptions.checkVideoTracksReleased(connectOptions.getVideoTracks());
        Listener listener = this.roomListenerProxy;
        synchronized (listener) {
            this.mediaFactory = MediaFactory.instance(this.context);
            this.cachedConnectOptions = connectOptions;
            this.nativeRoomDelegate = this.nativeConnect(connectOptions, this.roomListenerProxy, this.statsListenerProxy, this.mediaFactory.getNativeMediaFactoryHandle());
            this.mediaFactory.addRef();
            this.roomState = RoomState.CONNECTING;
        }
    }

    private synchronized Handler getHandler() {
        return this.handler;
    }

    private synchronized void setConnected(String roomSid, long nativeLocalParticipantHandle, String localParticipantSid, String localParticipantIdentity, List<Participant> participants) {
        logger.d("setConnected()");
        this.sid = roomSid;
        if (this.name == null || this.name.isEmpty()) {
            this.name = roomSid;
        }
        this.localParticipant = new LocalParticipant(nativeLocalParticipantHandle, localParticipantSid, localParticipantIdentity, this.cachedConnectOptions.getAudioTracks(), this.cachedConnectOptions.getVideoTracks());
        this.cachedConnectOptions = null;
        for (Participant participant : participants) {
            this.participantMap.put(participant.getSid(), participant);
        }
        this.roomState = RoomState.CONNECTED;
    }

    synchronized void releaseRoom() {
        if (this.nativeRoomDelegate != 0L) {
            for (Participant participant : this.participantMap.values()) {
                participant.release();
            }
            this.nativeReleaseRoom(this.nativeRoomDelegate);
            this.cleanupStatsListenerQueue();
        }
    }

    synchronized void release() {
        Preconditions.checkState(this.handlerThreadId == Looper.myLooper().getThread().getId());
        if (this.nativeRoomDelegate != 0L) {
            this.nativeRelease(this.nativeRoomDelegate);
            this.nativeRoomDelegate = 0L;
            this.mediaFactory.release();
        }
    }

    private void cleanupStatsListenerQueue() {
        for (final Pair pair : this.statsListenersQueue) {
            ((Handler)pair.first).post(new Runnable(){

                @Override
                public void run() {
                    ((StatsListener)pair.second).onStats(new ArrayList<StatsReport>());
                }
            });
        }
        this.statsListenersQueue.clear();
    }

    private native long nativeConnect(ConnectOptions var1, Listener var2, StatsListener var3, long var4);

    private native boolean nativeIsRecording(long var1);

    private native void nativeGetStats(long var1);

    private native void nativeOnNetworkChange(long var1, Video.NetworkChangeEvent var3);

    private native void nativeDisconnect(long var1);

    private native void nativeReleaseRoom(long var1);

    private native void nativeRelease(long var1);

    public static interface Listener {
        public void onConnected(Room var1);

        public void onConnectFailure(Room var1, TwilioException var2);

        public void onDisconnected(Room var1, TwilioException var2);

        public void onParticipantConnected(Room var1, Participant var2);

        public void onParticipantDisconnected(Room var1, Participant var2);

        public void onRecordingStarted(Room var1);

        public void onRecordingStopped(Room var1);
    }
}

