/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoFrame;
import org.webrtc.VideoCapturer;

final class VideoCapturerListenerAdapter
implements VideoCapturer.Listener {
    private final VideoCapturer.CapturerObserver webRtcCapturerObserver;

    public VideoCapturerListenerAdapter(VideoCapturer.CapturerObserver webRtcCapturerObserver) {
        this.webRtcCapturerObserver = webRtcCapturerObserver;
    }

    @Override
    public void onCapturerStarted(boolean success) {
        this.webRtcCapturerObserver.onCapturerStarted(success);
    }

    @Override
    public void onFrameCaptured(VideoFrame videoFrame) {
        if (videoFrame.imageBuffer != null) {
            this.webRtcCapturerObserver.onByteBufferFrameCaptured(videoFrame.imageBuffer, videoFrame.dimensions.width, videoFrame.dimensions.height, videoFrame.orientation.getValue(), videoFrame.timestamp);
        } else {
            this.webRtcCapturerObserver.onTextureFrameCaptured(videoFrame.dimensions.width, videoFrame.dimensions.height, videoFrame.textureId.intValue(), videoFrame.transformMatrix, videoFrame.orientation.getValue(), videoFrame.timestamp);
        }
    }
}

