/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.Nullable;
import com.twilio.video.IceOptions;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.PlatformInfo;
import com.twilio.video.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class ConnectOptions {
    private final String accessToken;
    private final String roomName;
    private final List<LocalAudioTrack> audioTracks;
    private final List<LocalVideoTrack> videoTracks;
    private final IceOptions iceOptions;

    static void checkAudioTracksReleased(@Nullable List<LocalAudioTrack> audioTracks) {
        if (audioTracks != null) {
            for (LocalAudioTrack localAudioTrack : audioTracks) {
                Preconditions.checkState(!localAudioTrack.isReleased(), "LocalAudioTrack cannot be released");
            }
        }
    }

    static void checkVideoTracksReleased(@Nullable List<LocalVideoTrack> videoTracks) {
        if (videoTracks != null) {
            for (LocalVideoTrack localVideoTrack : videoTracks) {
                Preconditions.checkState(!localVideoTrack.isReleased(), "LocalVideoTrack cannot be released");
            }
        }
    }

    private ConnectOptions(Builder builder) {
        this.accessToken = builder.accessToken;
        this.roomName = builder.roomName;
        this.audioTracks = builder.audioTracks;
        this.videoTracks = builder.videoTracks;
        this.iceOptions = builder.iceOptions;
    }

    String getAccessToken() {
        return this.accessToken;
    }

    String getRoomName() {
        return this.roomName;
    }

    List<LocalAudioTrack> getAudioTracks() {
        return this.audioTracks;
    }

    List<LocalVideoTrack> getVideoTracks() {
        return this.videoTracks;
    }

    IceOptions getIceOptions() {
        return this.iceOptions;
    }

    private LocalAudioTrack[] getLocalAudioTracksArray() {
        LocalAudioTrack[] audioTracksArray = new LocalAudioTrack[]{};
        if (this.audioTracks != null && this.audioTracks.size() > 0) {
            audioTracksArray = new LocalAudioTrack[this.audioTracks.size()];
            audioTracksArray = this.audioTracks.toArray(audioTracksArray);
        }
        return audioTracksArray;
    }

    private LocalVideoTrack[] getLocalVideoTracksArray() {
        LocalVideoTrack[] videoTracksArray = new LocalVideoTrack[]{};
        if (this.videoTracks != null && this.videoTracks.size() > 0) {
            videoTracksArray = new LocalVideoTrack[this.videoTracks.size()];
            videoTracksArray = this.videoTracks.toArray(videoTracksArray);
        }
        return videoTracksArray;
    }

    private long createNativeConnectOptionsBuilder() {
        ConnectOptions.checkAudioTracksReleased(this.audioTracks);
        ConnectOptions.checkVideoTracksReleased(this.videoTracks);
        return this.nativeCreate(this.accessToken, this.roomName, this.getLocalAudioTracksArray(), this.getLocalVideoTracksArray(), this.iceOptions, false, PlatformInfo.getNativeHandle());
    }

    private native long nativeCreate(String var1, String var2, LocalAudioTrack[] var3, LocalVideoTrack[] var4, IceOptions var5, boolean var6, long var7);

    public static class Builder {
        private String accessToken = "";
        private String roomName = "";
        private IceOptions iceOptions;
        private List<LocalAudioTrack> audioTracks;
        private List<LocalVideoTrack> videoTracks;

        public Builder(String accessToken) {
            this.accessToken = accessToken;
        }

        public Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public Builder audioTracks(List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "LocalAudioTrack List must not be null");
            this.audioTracks = new ArrayList<LocalAudioTrack>(audioTracks);
            return this;
        }

        public Builder videoTracks(List<LocalVideoTrack> videoTracks) {
            Preconditions.checkNotNull(videoTracks, "LocalVideoTrack List must not be null");
            this.videoTracks = new ArrayList<LocalVideoTrack>(videoTracks);
            return this;
        }

        public Builder iceOptions(IceOptions iceOptions) {
            this.iceOptions = iceOptions;
            return this;
        }

        public ConnectOptions build() {
            Preconditions.checkNotNull(this.accessToken, "Token must not be null.");
            Preconditions.checkArgument(!this.accessToken.equals(""), "Token must not be empty.");
            ConnectOptions.checkAudioTracksReleased(this.audioTracks);
            ConnectOptions.checkVideoTracksReleased(this.videoTracks);
            return new ConnectOptions(this);
        }
    }
}

