/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.ImageFormat;
import android.hardware.Camera;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.webrtc.CameraEnumerator;
import org.webrtc.Logging;

public class CameraEnumerationAndroid {
    private static final String TAG = "CameraEnumerationAndroid";
    private static Enumerator enumerator = new CameraEnumerator();

    public static synchronized void setEnumerator(Enumerator enumerator) {
        CameraEnumerationAndroid.enumerator = enumerator;
    }

    public static synchronized List<CaptureFormat> getSupportedFormats(int cameraId) {
        List<CaptureFormat> formats = enumerator.getSupportedFormats(cameraId);
        Logging.d(TAG, "Supported formats for camera " + cameraId + ": " + formats);
        return formats;
    }

    public static String[] getDeviceNames() {
        String[] names = new String[Camera.getNumberOfCameras()];
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            names[i] = CameraEnumerationAndroid.getDeviceName(i);
        }
        return names;
    }

    public static int getDeviceCount() {
        return Camera.getNumberOfCameras();
    }

    public static String getDeviceName(int index) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)info);
        }
        catch (Exception e) {
            Logging.e(TAG, "getCameraInfo failed on index " + index, e);
            return null;
        }
        String facing = info.facing == 1 ? "front" : "back";
        return "Camera " + index + ", Facing " + facing + ", Orientation " + info.orientation;
    }

    public static String getNameOfFrontFacingDevice() {
        return CameraEnumerationAndroid.getNameOfDevice(1);
    }

    public static String getNameOfBackFacingDevice() {
        return CameraEnumerationAndroid.getNameOfDevice(0);
    }

    public static int[] getFramerateRange(Camera.Parameters parameters, final int framerate) {
        List listFpsRange = parameters.getSupportedPreviewFpsRange();
        if (listFpsRange.isEmpty()) {
            Logging.w(TAG, "No supported preview fps range");
            return new int[]{0, 0};
        }
        return Collections.min(listFpsRange, new ClosestComparator<int[]>(){

            @Override
            int diff(int[] range) {
                int maxFpsWeight = 10;
                return range[0] + 10 * Math.abs(framerate - range[1]);
            }
        });
    }

    public static Camera.Size getClosestSupportedSize(List<Camera.Size> supportedSizes, final int requestedWidth, final int requestedHeight) {
        return Collections.min(supportedSizes, new ClosestComparator<Camera.Size>(){

            @Override
            int diff(Camera.Size size) {
                return Math.abs(requestedWidth - size.width) + Math.abs(requestedHeight - size.height);
            }
        });
    }

    private static String getNameOfDevice(int facing) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            try {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing != facing) continue;
                return CameraEnumerationAndroid.getDeviceName(i);
            }
            catch (Exception e) {
                Logging.e(TAG, "getCameraInfo() failed on index " + i, e);
            }
        }
        return null;
    }

    private static abstract class ClosestComparator<T>
    implements Comparator<T> {
        private ClosestComparator() {
        }

        abstract int diff(T var1);

        @Override
        public int compare(T t1, T t2) {
            return this.diff(t1) - this.diff(t2);
        }
    }

    public static class CaptureFormat {
        public final int width;
        public final int height;
        public final int maxFramerate;
        public final int minFramerate;
        public final int imageFormat;

        public CaptureFormat(int width, int height, int minFramerate, int maxFramerate) {
            this(width, height, minFramerate, maxFramerate, 17);
        }

        public CaptureFormat(int width, int height, int minFramerate, int maxFramerate, int imageFormat) {
            this.width = width;
            this.height = height;
            this.minFramerate = minFramerate;
            this.maxFramerate = maxFramerate;
            this.imageFormat = imageFormat;
        }

        public int frameSize() {
            return CaptureFormat.frameSize(this.width, this.height, this.imageFormat);
        }

        public static int frameSize(int width, int height, int imageFormat) {
            if (imageFormat != 17) {
                throw new UnsupportedOperationException("Don't know how to calculate the frame size of non-NV21 image formats.");
            }
            return width * height * ImageFormat.getBitsPerPixel((int)imageFormat) / 8;
        }

        public String toString() {
            return this.width + "x" + this.height + "@[" + this.minFramerate + ":" + this.maxFramerate + "]";
        }

        public boolean isSameFormat(CaptureFormat that) {
            if (that == null) {
                return false;
            }
            return this.width == that.width && this.height == that.height && this.maxFramerate == that.maxFramerate && this.minFramerate == that.minFramerate;
        }
    }

    public static interface Enumerator {
        public List<CaptureFormat> getSupportedFormats(int var1);
    }
}

