/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import com.twilio.video.EglBaseProvider;
import com.twilio.video.I420Frame;
import com.twilio.video.R;
import com.twilio.video.VideoRenderer;
import com.twilio.video.VideoScaleType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceViewRenderer;
import org.webrtc.VideoRenderer;

public class VideoView
extends SurfaceViewRenderer
implements VideoRenderer {
    private final Handler uiThreadHandler = new Handler(Looper.getMainLooper());
    private final RendererCommon.RendererEvents internalEventListener = new RendererCommon.RendererEvents(){

        public void onFirstFrameRendered() {
            VideoView.this.refreshRenderer();
            if (VideoView.this.listener != null) {
                VideoView.this.listener.onFirstFrame();
            }
        }

        public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
            VideoView.this.refreshRenderer();
            if (VideoView.this.listener != null) {
                VideoView.this.listener.onFrameDimensionsChanged(videoWidth, videoHeight, rotation);
            }
        }
    };
    private boolean mirror = false;
    private boolean overlaySurface = false;
    private VideoScaleType videoScaleType = VideoScaleType.ASPECT_FIT;
    private VideoRenderer.Listener listener;

    public VideoView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.VideoView, 0, 0);
        try {
            this.mirror = a.getBoolean(R.styleable.VideoView_mirror, false);
            this.videoScaleType = VideoScaleType.fromInt(a.getInteger(R.styleable.VideoView_scaleType, 0));
            this.overlaySurface = a.getBoolean(R.styleable.VideoView_overlaySurface, false);
        }
        finally {
            a.recycle();
        }
        this.setupRenderer();
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
        super.setMirror(mirror);
        this.refreshRenderer();
    }

    public VideoScaleType getVideoScaleType() {
        return this.videoScaleType;
    }

    public void setVideoScaleType(VideoScaleType videoScaleType) {
        this.videoScaleType = videoScaleType;
        this.setScalingType(this.convertToWebRtcScaleType(videoScaleType));
        this.refreshRenderer();
    }

    public void setListener(VideoRenderer.Listener listener) {
        this.listener = listener;
    }

    public void release() {
        super.release();
    }

    @Override
    public void renderFrame(I420Frame frame) {
        super.renderFrame(this.convertToWebRtcFrame(frame));
    }

    public void applyZOrder(boolean overlaySurface) {
        this.overlaySurface = overlaySurface;
        this.setZOrderMediaOverlay(overlaySurface);
    }

    private void setupRenderer() {
        this.init(EglBaseProvider.provideEglBase().getEglBaseContext(), this.internalEventListener);
        this.setMirror(this.mirror);
        this.setScalingType(this.convertToWebRtcScaleType(this.videoScaleType));
        this.setZOrderMediaOverlay(this.overlaySurface);
    }

    private void refreshRenderer() {
        this.uiThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoView.this.requestLayout();
            }
        });
    }

    private RendererCommon.ScalingType convertToWebRtcScaleType(VideoScaleType videoScaleType) {
        switch (videoScaleType) {
            case ASPECT_FIT: {
                return RendererCommon.ScalingType.SCALE_ASPECT_FIT;
            }
            case ASPECT_FILL: {
                return RendererCommon.ScalingType.SCALE_ASPECT_FILL;
            }
            case ASPECT_BALANCED: {
                return RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
            }
        }
        return RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    }

    private VideoRenderer.I420Frame convertToWebRtcFrame(I420Frame frame) {
        try {
            Constructor i420FrameConstructor = VideoRenderer.I420Frame.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class, ByteBuffer[].class, Long.TYPE);
            i420FrameConstructor.setAccessible(true);
            return (VideoRenderer.I420Frame)i420FrameConstructor.newInstance(frame.width, frame.height, frame.rotationDegree, frame.yuvStrides, frame.yuvPlanes, frame.nativeFramePointer);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to transform I420 frame");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to transform I420 frame");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to transform I420 frame");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to transform I420 frame");
        }
    }
}

