/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.hardware.Camera;
import com.twilio.video.CameraCapturer;
import com.twilio.video.Logger;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoPixelFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webrtc.CameraEnumerationAndroid;

class CameraCapturerFormatProvider {
    private static final Logger logger = Logger.getLogger(CameraCapturerFormatProvider.class);
    private final Map<CameraCapturer.CameraSource, List<VideoFormat>> supportedFormatsMap = new HashMap<CameraCapturer.CameraSource, List<VideoFormat>>();

    CameraCapturerFormatProvider() {
    }

    static int getCameraId(CameraCapturer.CameraSource cameraSource) {
        int cameraId = -1;
        String deviceName = cameraSource == CameraCapturer.CameraSource.CAMERA_SOURCE_BACK_CAMERA ? CameraEnumerationAndroid.getNameOfBackFacingDevice() : CameraEnumerationAndroid.getNameOfFrontFacingDevice();
        if (deviceName == null) {
            cameraId = -1;
        } else {
            String[] deviceNames = CameraEnumerationAndroid.getDeviceNames();
            for (int i = 0; i < deviceNames.length; ++i) {
                if (!deviceName.equals(deviceNames[i])) continue;
                cameraId = i;
                break;
            }
        }
        return cameraId;
    }

    List<VideoFormat> getSupportedFormats(CameraCapturer.CameraSource cameraSource) {
        List<VideoFormat> supportedFormats = this.supportedFormatsMap.get((Object)cameraSource);
        if (supportedFormats == null) {
            supportedFormats = this.getSupportedFormats(CameraCapturerFormatProvider.getCameraId(cameraSource));
            this.supportedFormatsMap.put(cameraSource, supportedFormats);
        }
        return supportedFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VideoFormat> getSupportedFormats(int cameraId) {
        Camera.Parameters parameters;
        Camera camera = null;
        try {
            camera = Camera.open((int)cameraId);
            parameters = camera.getParameters();
        }
        catch (RuntimeException e) {
            ArrayList<VideoFormat> arrayList = new ArrayList<VideoFormat>();
            return arrayList;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        ArrayList<VideoFormat> formatList = new ArrayList<VideoFormat>();
        try {
            int maxFps = 0;
            List listFpsRange = parameters.getSupportedPreviewFpsRange();
            if (listFpsRange != null) {
                int[] range = (int[])listFpsRange.get(listFpsRange.size() - 1);
                maxFps = (range[1] + 999) / 1000;
            }
            for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
                VideoDimensions dimensions = new VideoDimensions(size.width, size.height);
                formatList.add(new VideoFormat(dimensions, maxFps, VideoPixelFormat.NV21));
            }
        }
        catch (Exception e) {
            logger.e("getSupportedFormats() failed on camera index " + cameraId, e);
        }
        return formatList;
    }
}

