/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.AudioTrack;
import com.twilio.video.Logger;

public class LocalAudioTrack
extends AudioTrack {
    private static final Logger logger = Logger.getLogger(LocalAudioTrack.class);
    private long nativeLocalAudioTrackHandle;

    LocalAudioTrack(long nativeLocalAudioTrackHandle, String trackId, boolean enabled) {
        super(trackId, enabled);
        this.nativeLocalAudioTrackHandle = nativeLocalAudioTrackHandle;
    }

    @Override
    public synchronized boolean isEnabled() {
        if (!this.isReleased()) {
            return this.nativeIsEnabled(this.nativeLocalAudioTrackHandle);
        }
        logger.e("Local audio track is not enabled because it has been removed");
        return false;
    }

    public synchronized void enable(boolean enable) {
        if (!this.isReleased()) {
            this.nativeEnable(this.nativeLocalAudioTrackHandle, enable);
        } else {
            logger.e("Cannot enable a local audio track that has been removed");
        }
    }

    synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalAudioTrackHandle);
            this.nativeLocalAudioTrackHandle = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeLocalAudioTrackHandle == 0L;
    }

    private native boolean nativeIsEnabled(long var1);

    private native void nativeEnable(long var1, boolean var3);

    private native void nativeRelease(long var1);
}

