/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.hardware.Camera;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.twilio.video.CameraCapturerFormatProvider;
import com.twilio.video.CameraParameterUpdater;
import com.twilio.video.Logger;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoFrame;
import com.twilio.video.VideoPixelFormat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoCapturerAndroid;

public class CameraCapturer
implements VideoCapturer {
    private static final String ERROR_MESSAGE_CAMERA_SERVER_DIED = "Camera server died!";
    private static final String ERROR_MESSAGE_UNKNOWN = "Camera error:";
    private static final Logger logger = Logger.getLogger(CameraCapturer.class);
    public static final int ERROR_CAMERA_FREEZE = 0;
    public static final int ERROR_CAMERA_SERVER_STOPPED = 1;
    public static final int ERROR_UNSUPPORTED_SOURCE = 2;
    public static final int ERROR_CAMERA_PERMISSION_NOT_GRANTED = 3;
    public static final int ERROR_CAPTURER_CREATION_FAILED = 4;
    public static final int ERROR_CAMERA_SWITCH_FAILED = 5;
    public static final int ERROR_UNKNOWN = 6;
    private final Context context;
    private final CameraCapturerFormatProvider formatProvider = new CameraCapturerFormatProvider();
    private Listener listener;
    private VideoCapturerAndroid webrtcCapturer;
    private CameraSource cameraSource;
    private VideoCapturer.Listener videoCapturerListener;
    private SurfaceTextureHelper surfaceTextureHelper;
    private final VideoCapturer.CapturerObserver observerAdapter = new VideoCapturer.CapturerObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapturerStarted(boolean success) {
            CameraCapturer.this.videoCapturerListener.onCapturerStarted(success);
            CameraCapturer cameraCapturer = CameraCapturer.this;
            synchronized (cameraCapturer) {
                boolean parameterUpdatedScheduled;
                if (CameraCapturer.this.cameraParameterUpdater != null && !(parameterUpdatedScheduled = CameraCapturer.this.webrtcCapturer.injectCameraParameters(CameraCapturer.this.cameraParameterInjector))) {
                    logger.e("Failed to schedule camera parameter update after capturer started.");
                }
            }
        }

        public void onByteBufferFrameCaptured(byte[] bytes, int width, int height, int rotation, long timestamp) {
            VideoDimensions frameDimensions = new VideoDimensions(width, height);
            VideoFrame frame = new VideoFrame(bytes, frameDimensions, rotation, timestamp);
            CameraCapturer.this.videoCapturerListener.onFrameCaptured(frame);
        }

        public void onTextureFrameCaptured(int width, int height, int oesTextureId, float[] transformMatrix, int rotation, long timestampNs) {
        }

        public void onOutputFormatRequest(int width, int height, int framerate) {
        }
    };
    private final VideoCapturerAndroid.CameraParameterInjector cameraParameterInjector = new VideoCapturerAndroid.CameraParameterInjector(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraParameters(Camera.Parameters parameters) {
            CameraCapturer cameraCapturer = CameraCapturer.this;
            synchronized (cameraCapturer) {
                if (CameraCapturer.this.cameraParameterUpdater != null) {
                    logger.i("Updating camera parameters");
                    CameraCapturer.this.cameraParameterUpdater.apply(parameters);
                }
            }
        }
    };
    private CameraParameterUpdater cameraParameterUpdater;
    private final VideoCapturerAndroid.CameraEventsHandler cameraEventsHandler = new VideoCapturerAndroid.CameraEventsHandler(){

        public void onCameraError(String errorMsg) {
            if (CameraCapturer.this.listener != null) {
                if (errorMsg.equals(CameraCapturer.ERROR_MESSAGE_CAMERA_SERVER_DIED)) {
                    logger.e("Camera server stopped.");
                    CameraCapturer.this.listener.onError(1);
                } else if (errorMsg.contains(CameraCapturer.ERROR_MESSAGE_UNKNOWN)) {
                    logger.e("Unknown camera error occurred.");
                    CameraCapturer.this.listener.onError(6);
                }
            }
        }

        public void onCameraFreezed(String s) {
            logger.e("Camera froze.");
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onError(0);
            }
        }

        public void onCameraOpening(int i) {
        }

        public void onFirstFrameAvailable() {
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onFirstFrameAvailable();
            }
        }

        public void onCameraClosed() {
        }
    };
    private final VideoCapturerAndroid.CameraSwitchHandler cameraSwitchHandler = new VideoCapturerAndroid.CameraSwitchHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchDone(boolean isFrontCamera) {
            CameraCapturer cameraCapturer = CameraCapturer.this;
            synchronized (cameraCapturer) {
                CameraCapturer.this.cameraSource = CameraCapturer.this.cameraSource == CameraSource.FRONT_CAMERA ? CameraSource.BACK_CAMERA : CameraSource.FRONT_CAMERA;
            }
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onCameraSwitched();
            }
        }

        public void onCameraSwitchError(String errorMessage) {
            logger.e("Failed to switch to camera source " + (Object)((Object)CameraCapturer.this.cameraSource));
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onError(5);
            }
        }
    };
    private PictureListener pictureListener;
    private final VideoCapturerAndroid.PictureEventHandler pictureEventHandler = new VideoCapturerAndroid.PictureEventHandler(){

        public void onShutter() {
            if (CameraCapturer.this.pictureListener != null) {
                CameraCapturer.this.pictureListener.onShutter();
            }
        }

        public void onPictureTaken(byte[] pictureData) {
            if (CameraCapturer.this.pictureListener != null) {
                CameraCapturer.this.pictureListener.onPictureTaken(pictureData);
            }
        }
    };

    public CameraCapturer(Context context, CameraSource cameraSource) {
        this(context, cameraSource, null);
    }

    public CameraCapturer(Context context, CameraSource cameraSource, @Nullable Listener listener) {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (cameraSource == null) {
            throw new NullPointerException("camera source must not be null");
        }
        this.context = context;
        this.cameraSource = cameraSource;
        this.listener = listener;
    }

    @Override
    public List<VideoFormat> getSupportedFormats() {
        if (Util.permissionGranted(this.context, "android.permission.CAMERA")) {
            return this.formatProvider.getSupportedFormats(this.cameraSource);
        }
        return this.defaultFormats();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    @Override
    public void startCapture(VideoFormat captureFormat, VideoCapturer.Listener videoCapturerListener) {
        boolean capturerCreated = this.createVideoCapturerAndroid();
        if (capturerCreated) {
            this.videoCapturerListener = videoCapturerListener;
            this.webrtcCapturer.startCapture(captureFormat.dimensions.width, captureFormat.dimensions.height, captureFormat.framerate, this.surfaceTextureHelper, this.context, this.observerAdapter);
        } else {
            logger.e("Failed to startCapture");
            videoCapturerListener.onCapturerStarted(false);
        }
    }

    @Override
    public void stopCapture() {
        if (this.webrtcCapturer != null) {
            try {
                this.webrtcCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                logger.e("Failed to stop camera capturer");
            }
            this.webrtcCapturer.dispose();
            this.webrtcCapturer = null;
        }
    }

    public synchronized CameraSource getCameraSource() {
        return this.cameraSource;
    }

    public synchronized void switchCamera() {
        if (this.webrtcCapturer != null) {
            this.webrtcCapturer.switchCamera(this.cameraSwitchHandler);
        } else {
            CameraSource cameraSource = this.cameraSource = this.cameraSource == CameraSource.FRONT_CAMERA ? CameraSource.BACK_CAMERA : CameraSource.FRONT_CAMERA;
            if (this.listener != null) {
                this.listener.onCameraSwitched();
            }
        }
    }

    public synchronized boolean updateCameraParameters(CameraParameterUpdater cameraParameterUpdater) {
        boolean parameterUpdateScheduled = true;
        if (this.webrtcCapturer != null) {
            parameterUpdateScheduled = this.webrtcCapturer.injectCameraParameters(this.cameraParameterInjector);
        }
        if (parameterUpdateScheduled) {
            this.cameraParameterUpdater = cameraParameterUpdater;
        }
        return parameterUpdateScheduled;
    }

    public synchronized boolean takePicture(@NonNull PictureListener pictureListener) {
        if (this.webrtcCapturer != null) {
            this.pictureListener = pictureListener;
            return this.webrtcCapturer.takePicture(this.pictureEventHandler);
        }
        logger.e("Picture cannot be taken unless camera capturer is running");
        return false;
    }

    void setSurfaceTextureHelper(SurfaceTextureHelper surfaceTextureHelper) {
        this.surfaceTextureHelper = surfaceTextureHelper;
    }

    private List<VideoFormat> defaultFormats() {
        ArrayList<VideoFormat> defaultFormats = new ArrayList<VideoFormat>();
        VideoDimensions defaultDimensions = new VideoDimensions(640, 480);
        VideoFormat defaultFormat = new VideoFormat(defaultDimensions, 30, VideoPixelFormat.NV21);
        defaultFormats.add(defaultFormat);
        return defaultFormats;
    }

    private boolean createVideoCapturerAndroid() {
        if (!Util.permissionGranted(this.context, "android.permission.CAMERA")) {
            logger.e("CAMERA permission must be granted to start capturer");
            if (this.listener != null) {
                this.listener.onError(3);
            }
            return false;
        }
        int cameraId = CameraCapturerFormatProvider.getCameraId(this.cameraSource);
        String deviceName = CameraEnumerationAndroid.getDeviceName((int)cameraId);
        if (cameraId < 0 || deviceName == null) {
            logger.e("Failed to find camera source");
            if (this.listener != null) {
                this.listener.onError(2);
            }
            return false;
        }
        this.webrtcCapturer = VideoCapturerAndroid.create((String)deviceName, (VideoCapturerAndroid.CameraEventsHandler)this.cameraEventsHandler);
        if (this.webrtcCapturer == null) {
            logger.e("Failed to create capturer");
            if (this.listener != null) {
                this.listener.onError(4);
            }
            return false;
        }
        return true;
    }

    public static interface PictureListener {
        public void onShutter();

        public void onPictureTaken(byte[] var1);
    }

    public static interface Listener {
        public void onFirstFrameAvailable();

        public void onCameraSwitched();

        public void onError(int var1);
    }

    public static enum CameraSource {
        FRONT_CAMERA,
        BACK_CAMERA;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Error {
    }
}

