/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.video.AudioOutput;
import com.twilio.video.ConnectOptions;
import com.twilio.video.LogLevel;
import com.twilio.video.LogModule;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Participant;
import com.twilio.video.Room;
import com.twilio.video.RoomState;
import com.twilio.video.Util;
import com.twilio.video.VideoException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VideoClient {
    private static LogLevel level = LogLevel.OFF;
    private static Map<LogModule, LogLevel> moduleLogLevel = new EnumMap<LogModule, LogLevel>(LogModule.class);
    private static volatile boolean libraryIsLoaded = false;
    private static final Logger logger = Logger.getLogger(VideoClient.class);
    private final Handler handler;
    private final Context applicationContext;
    private final Set<Room> rooms = new HashSet<Room>();
    private final BroadcastReceiver connectivityChangeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.net.conn.CONNECTIVITY_CHANGE")) {
                ConnectivityManager conn = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = conn.getActiveNetworkInfo();
                NetworkChangeEvent networkChangeEvent = NetworkChangeEvent.CONNECTION_CHANGED;
                if (networkInfo == null || !networkInfo.isConnectedOrConnecting()) {
                    networkChangeEvent = NetworkChangeEvent.CONNECTION_LOST;
                } else if (networkInfo.isConnected()) {
                    networkChangeEvent = NetworkChangeEvent.CONNECTION_CHANGED;
                }
                logger.d("Network event detected: " + networkChangeEvent.name());
                VideoClient.this.nativeOnNetworkChange(VideoClient.this.nativeClientContext, networkChangeEvent);
            }
        }
    };
    private String token;
    private long nativeClientContext;

    public VideoClient(Context context, String token) {
        if (context == null) {
            throw new NullPointerException("applicationContext must not be null");
        }
        if (token == null) {
            throw new NullPointerException("accessManager must not be null");
        }
        this.applicationContext = context.getApplicationContext();
        this.token = token;
        this.handler = Util.createCallbackHandler();
        if (!libraryIsLoaded) {
            ReLinker.loadLibrary((Context)this.applicationContext, (String)"jingle_peerconnection_so");
            libraryIsLoaded = true;
        }
        VideoClient.trySetCoreLogLevel(level.ordinal());
        for (LogModule module : moduleLogLevel.keySet()) {
            VideoClient.trySetCoreModuleLogLevel(module.ordinal(), moduleLogLevel.get((Object)module).ordinal());
        }
    }

    public void setAudioOutput(AudioOutput audioOutput) {
        AudioManager audioManager = (AudioManager)this.applicationContext.getSystemService("audio");
        if (audioOutput == AudioOutput.SPEAKERPHONE) {
            audioManager.setSpeakerphoneOn(true);
        } else {
            audioManager.setSpeakerphoneOn(false);
        }
    }

    public AudioOutput getAudioOutput() {
        AudioManager audioManager = (AudioManager)this.applicationContext.getSystemService("audio");
        return audioManager.isSpeakerphoneOn() ? AudioOutput.SPEAKERPHONE : AudioOutput.HEADSET;
    }

    public Room connect(Room.Listener roomListener) {
        if (roomListener == null) {
            throw new NullPointerException("roomListener must not be null");
        }
        ConnectOptions connectOptions = new ConnectOptions.Builder().build();
        return this.connect(connectOptions, roomListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Room connect(ConnectOptions connectOptions, Room.Listener roomListener) {
        if (connectOptions == null) {
            throw new NullPointerException("connectOptions must not be null");
        }
        if (roomListener == null) {
            throw new NullPointerException("roomListener must not be null");
        }
        if (this.rooms.isEmpty()) {
            this.nativeClientContext = this.nativeCreateClient(this.applicationContext, this.token, MediaFactory.instance(this.applicationContext).getNativeMediaFactoryHandle());
            this.registerConnectivityBroadcastReceiver();
        }
        this.nativeUpdateToken(this.nativeClientContext, this.token);
        Room room = new Room(connectOptions.getRoomName(), connectOptions.getLocalMedia(), this.roomListenerProxy(roomListener), this.handler);
        this.rooms.add(room);
        Object object = room.getConnectLock();
        synchronized (object) {
            long nativeRoomContext = this.nativeConnect(this.nativeClientContext, room.getListenerNativeHandle(), connectOptions);
            room.setNativeContext(nativeRoomContext);
            room.setState(RoomState.CONNECTING);
        }
        return room;
    }

    public synchronized void updateToken(String token) {
        this.token = token;
    }

    synchronized void release(Room room) {
        this.rooms.remove(room);
        if (this.rooms.isEmpty() && this.nativeClientContext != 0L) {
            this.unregisterConnectivityBroadcastReceiver();
            this.nativeRelease(this.nativeClientContext);
            this.nativeClientContext = 0L;
        }
    }

    private Room.Listener roomListenerProxy(final Room.Listener roomListener) {
        return new Room.Listener(){

            @Override
            public void onConnected(Room room) {
                roomListener.onConnected(room);
            }

            @Override
            public void onConnectFailure(Room room, VideoException error) {
                roomListener.onConnectFailure(room, error);
                VideoClient.this.release(room);
            }

            @Override
            public void onDisconnected(Room room, VideoException error) {
                roomListener.onDisconnected(room, error);
                VideoClient.this.release(room);
            }

            @Override
            public void onParticipantConnected(Room room, Participant participant) {
                roomListener.onParticipantConnected(room, participant);
            }

            @Override
            public void onParticipantDisconnected(Room room, Participant participant) {
                roomListener.onParticipantDisconnected(room, participant);
            }
        };
    }

    public static String getVersion() {
        return "1.0.0-beta2";
    }

    public static LogLevel getLogLevel() {
        return LogLevel.values()[VideoClient.tryGetCoreLogLevel()];
    }

    public static void setLogLevel(LogLevel level) {
        VideoClient.setSDKLogLevel(level);
        VideoClient.trySetCoreLogLevel(level.ordinal());
        VideoClient.level = level;
    }

    public static void setModuleLogLevel(LogModule module, LogLevel level) {
        if (module == LogModule.PLATFORM) {
            VideoClient.setSDKLogLevel(level);
        }
        VideoClient.trySetCoreModuleLogLevel(module.ordinal(), level.ordinal());
        moduleLogLevel.put(module, level);
    }

    private static void setSDKLogLevel(LogLevel level) {
        switch (level) {
            case OFF: {
                Logger.setLogLevel(7);
                break;
            }
            case FATAL: {
                Logger.setLogLevel(6);
                break;
            }
            case ERROR: {
                Logger.setLogLevel(6);
                break;
            }
            case WARNING: {
                Logger.setLogLevel(5);
                break;
            }
            case INFO: {
                Logger.setLogLevel(4);
                break;
            }
            case DEBUG: {
                Logger.setLogLevel(3);
                break;
            }
            case TRACE: {
                Logger.setLogLevel(2);
                break;
            }
            case ALL: {
                Logger.setLogLevel(2);
                break;
            }
            default: {
                Logger.setLogLevel(7);
            }
        }
    }

    private static void trySetCoreLogLevel(int level) {
        if (libraryIsLoaded) {
            VideoClient.nativeSetCoreLogLevel(level);
        }
    }

    private static int tryGetCoreLogLevel() {
        return libraryIsLoaded ? VideoClient.nativeGetCoreLogLevel() : level.ordinal();
    }

    private static void trySetCoreModuleLogLevel(int module, int level) {
        if (libraryIsLoaded) {
            VideoClient.nativeSetModuleLevel(module, level);
        }
    }

    private void registerConnectivityBroadcastReceiver() {
        this.applicationContext.registerReceiver(this.connectivityChangeReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private void unregisterConnectivityBroadcastReceiver() {
        this.applicationContext.unregisterReceiver(this.connectivityChangeReceiver);
    }

    private static native void nativeSetCoreLogLevel(int var0);

    private static native void nativeSetModuleLevel(int var0, int var1);

    private static native int nativeGetCoreLogLevel();

    private native long nativeCreateClient(Context var1, String var2, long var3);

    private native long nativeConnect(long var1, long var3, ConnectOptions var5);

    private native void nativeUpdateToken(long var1, String var3);

    private native void nativeOnNetworkChange(long var1, NetworkChangeEvent var3);

    private native void nativeRelease(long var1);

    static enum NetworkChangeEvent {
        CONNECTION_LOST,
        CONNECTION_CHANGED;

    }
}

