/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import com.twilio.video.AudioOptions;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoConstraints;
import java.util.ArrayList;
import java.util.List;

public class LocalMedia {
    private static final String RELEASE_MESSAGE_TEMPLATE = "LocalMedia released %s unavailable";
    private static final Logger logger = Logger.getLogger(LocalMedia.class);
    private long nativeLocalMediaHandle;
    private final List<LocalAudioTrack> localAudioTracks = new ArrayList<LocalAudioTrack>();
    private final List<LocalVideoTrack> localVideoTracks = new ArrayList<LocalVideoTrack>();
    private final MediaFactory mediaFactory;

    public static LocalMedia create(Context context) {
        return MediaFactory.instance(context).createLocalMedia();
    }

    LocalMedia(long nativeLocalMediaHandle, MediaFactory mediaFactory) {
        this.nativeLocalMediaHandle = nativeLocalMediaHandle;
        this.mediaFactory = mediaFactory;
    }

    public List<LocalAudioTrack> getAudioTracks() {
        this.checkReleased("getAudioTracks");
        return this.localAudioTracks;
    }

    public List<LocalVideoTrack> getVideoTracks() {
        this.checkReleased("getVideoTracks");
        return this.localVideoTracks;
    }

    public LocalAudioTrack addAudioTrack(boolean enabled) {
        return this.addAudioTrack(enabled, null);
    }

    public LocalAudioTrack addAudioTrack(boolean enabled, AudioOptions audioOptions) {
        this.checkReleased("addAudioTrack");
        LocalAudioTrack localAudioTrack = this.nativeAddAudioTrack(this.nativeLocalMediaHandle, enabled, audioOptions);
        if (localAudioTrack != null) {
            this.localAudioTracks.add(localAudioTrack);
            return localAudioTrack;
        }
        logger.e("Failed to create local audio track");
        return localAudioTrack;
    }

    public boolean removeAudioTrack(LocalAudioTrack localAudioTrack) {
        this.checkReleased("removeAudioTrack");
        boolean result = false;
        if (localAudioTrack != null && this.localAudioTracks.contains(localAudioTrack)) {
            localAudioTrack.release();
            result = this.nativeRemoveAudioTrack(this.nativeLocalMediaHandle, localAudioTrack.getTrackId());
            if (!result) {
                logger.e("Failed to remove audio track");
            } else {
                this.localAudioTracks.remove(localAudioTrack);
            }
        }
        return result;
    }

    public LocalVideoTrack addVideoTrack(boolean enabled, VideoCapturer videoCapturer) {
        return this.addVideoTrack(enabled, videoCapturer, null);
    }

    public LocalVideoTrack addVideoTrack(boolean enabled, VideoCapturer videoCapturer, VideoConstraints videoConstraints) {
        this.checkReleased("addVideoTrack");
        LocalVideoTrack localVideoTrack = this.nativeAddVideoTrack(this.nativeLocalMediaHandle, enabled, videoCapturer, videoConstraints);
        if (localVideoTrack != null) {
            this.localVideoTracks.add(localVideoTrack);
            return localVideoTrack;
        }
        logger.e("Failed to create local video track");
        return localVideoTrack;
    }

    public boolean removeVideoTrack(LocalVideoTrack localVideoTrack) {
        this.checkReleased("removeVideoTrack");
        boolean result = false;
        if (localVideoTrack != null && this.localVideoTracks.contains(localVideoTrack)) {
            localVideoTrack.release();
            result = this.nativeRemoveVideoTrack(this.nativeLocalMediaHandle, localVideoTrack.getTrackId());
            if (!result) {
                logger.e("Failed to remove video track");
            } else {
                this.localVideoTracks.remove(localVideoTrack);
            }
        }
        return result;
    }

    public void release() {
        if (this.nativeLocalMediaHandle != 0L) {
            while (!this.localAudioTracks.isEmpty()) {
                this.removeAudioTrack(this.localAudioTracks.get(0));
            }
            while (!this.localVideoTracks.isEmpty()) {
                this.removeVideoTrack(this.localVideoTracks.get(0));
            }
            this.nativeRelease(this.nativeLocalMediaHandle);
            this.nativeLocalMediaHandle = 0L;
            this.mediaFactory.release();
        }
    }

    long getNativeLocalMediaHandle() {
        return this.nativeLocalMediaHandle;
    }

    private void checkReleased(String methodName) {
        if (this.nativeLocalMediaHandle == 0L) {
            String releaseErrorMessage = String.format(RELEASE_MESSAGE_TEMPLATE, methodName);
            throw new IllegalStateException(releaseErrorMessage);
        }
    }

    private native LocalAudioTrack nativeAddAudioTrack(long var1, boolean var3, AudioOptions var4);

    private native boolean nativeRemoveAudioTrack(long var1, String var3);

    private native LocalVideoTrack nativeAddVideoTrack(long var1, boolean var3, VideoCapturer var4, VideoConstraints var5);

    private native boolean nativeRemoveVideoTrack(long var1, String var3);

    private native void nativeRelease(long var1);
}

