/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.support.annotation.Nullable;
import com.twilio.video.AspectRatio;
import com.twilio.video.AudioOptions;
import com.twilio.video.EglBaseProvider;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoConstraints;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.webrtc.EglBase;

public class LocalMedia {
    private static final double ASPECT_RATIO_TOLERANCE = 0.05;
    private static final String RELEASE_MESSAGE_TEMPLATE = "LocalMedia released %s unavailable";
    private static final Logger logger = Logger.getLogger(LocalMedia.class);
    static final VideoConstraints defaultVideoConstraints = new VideoConstraints.Builder().maxFps(30).maxVideoDimensions(VideoDimensions.VGA_VIDEO_DIMENSIONS).build();
    private final Context context;
    private final MediaFactory mediaFactory;
    private long nativeLocalMediaHandle;
    private EglBaseProvider eglBaseProvider;
    private final List<LocalAudioTrack> localAudioTracks = new ArrayList<LocalAudioTrack>();
    private final List<LocalVideoTrack> localVideoTracks = new ArrayList<LocalVideoTrack>();

    public static LocalMedia create(Context context) {
        return MediaFactory.instance(context).createLocalMedia(context);
    }

    LocalMedia(Context context, MediaFactory mediaFactory, long nativeLocalMediaHandle) {
        this.context = context;
        this.mediaFactory = mediaFactory;
        this.nativeLocalMediaHandle = nativeLocalMediaHandle;
        this.eglBaseProvider = EglBaseProvider.instance(this);
    }

    public List<LocalAudioTrack> getAudioTracks() {
        this.checkReleased("getAudioTracks");
        return this.localAudioTracks;
    }

    public List<LocalVideoTrack> getVideoTracks() {
        this.checkReleased("getVideoTracks");
        return this.localVideoTracks;
    }

    public LocalAudioTrack addAudioTrack(boolean enabled) {
        return this.addAudioTrack(enabled, null);
    }

    public LocalAudioTrack addAudioTrack(boolean enabled, AudioOptions audioOptions) {
        this.checkReleased("addAudioTrack");
        LocalAudioTrack localAudioTrack = null;
        if (Util.permissionGranted(this.context, "android.permission.RECORD_AUDIO")) {
            localAudioTrack = this.nativeAddAudioTrack(this.nativeLocalMediaHandle, enabled, audioOptions);
            if (localAudioTrack != null) {
                this.localAudioTracks.add(localAudioTrack);
                return localAudioTrack;
            }
            logger.e("Failed to create local audio track");
        } else {
            logger.e("RECORD_AUDIO permission must be granted to add audio track");
        }
        return localAudioTrack;
    }

    public boolean removeAudioTrack(LocalAudioTrack localAudioTrack) {
        this.checkReleased("removeAudioTrack");
        boolean result = false;
        if (localAudioTrack != null && this.localAudioTracks.contains(localAudioTrack)) {
            localAudioTrack.release();
            result = this.nativeRemoveAudioTrack(this.nativeLocalMediaHandle, localAudioTrack.getTrackId());
            if (!result) {
                logger.e("Failed to remove audio track");
            } else {
                this.localAudioTracks.remove(localAudioTrack);
            }
        }
        return result;
    }

    public LocalVideoTrack addVideoTrack(boolean enabled, VideoCapturer videoCapturer) {
        return this.addVideoTrack(enabled, videoCapturer, null);
    }

    public LocalVideoTrack addVideoTrack(boolean enabled, VideoCapturer videoCapturer, @Nullable VideoConstraints videoConstraints) {
        this.checkReleased("addVideoTrack");
        this.checkSupportedFormats(videoCapturer);
        LocalVideoTrack localVideoTrack = this.nativeAddVideoTrack(this.nativeLocalMediaHandle, enabled, videoCapturer, this.resolveConstraints(videoCapturer, videoConstraints), this.eglBaseProvider.getLocalEglBase().getEglBaseContext());
        if (localVideoTrack != null) {
            this.localVideoTracks.add(localVideoTrack);
            return localVideoTrack;
        }
        logger.e("Failed to create local video track");
        return localVideoTrack;
    }

    public boolean removeVideoTrack(LocalVideoTrack localVideoTrack) {
        this.checkReleased("removeVideoTrack");
        boolean result = false;
        if (localVideoTrack != null && this.localVideoTracks.contains(localVideoTrack)) {
            localVideoTrack.release();
            result = this.nativeRemoveVideoTrack(this.nativeLocalMediaHandle, localVideoTrack.getTrackId());
            if (!result) {
                logger.e("Failed to remove video track");
            } else {
                this.localVideoTracks.remove(localVideoTrack);
            }
        }
        return result;
    }

    public void release() {
        if (this.nativeLocalMediaHandle != 0L) {
            while (!this.localAudioTracks.isEmpty()) {
                this.removeAudioTrack(this.localAudioTracks.get(0));
            }
            while (!this.localVideoTracks.isEmpty()) {
                this.removeVideoTrack(this.localVideoTracks.get(0));
            }
            this.eglBaseProvider.release(this);
            this.eglBaseProvider = null;
            this.nativeRelease(this.nativeLocalMediaHandle);
            this.nativeLocalMediaHandle = 0L;
            this.mediaFactory.release();
        }
    }

    private VideoConstraints resolveConstraints(VideoCapturer videoCapturer, VideoConstraints videoConstraints) {
        if (videoConstraints == null || !this.constraintsCompatible(videoCapturer, videoConstraints)) {
            logger.e("Applying VideoConstraints closest to 640x480@30 FPS.");
            return this.getClosestCompatibleVideoConstraints(videoCapturer, defaultVideoConstraints);
        }
        return videoConstraints;
    }

    private boolean constraintsCompatible(VideoCapturer videoCapturer, VideoConstraints videoConstraints) {
        for (VideoFormat videoFormat : videoCapturer.getSupportedFormats()) {
            boolean formatCompatible;
            VideoDimensions minVideoDimensions = videoConstraints.getMinVideoDimensions();
            VideoDimensions maxVideoDimensions = videoConstraints.getMaxVideoDimensions();
            AspectRatio aspectRatio = videoConstraints.getAspectRatio();
            int minFps = videoConstraints.getMinFps();
            int maxFps = videoConstraints.getMaxFps();
            boolean bl = formatCompatible = minVideoDimensions.width <= videoFormat.dimensions.width && minVideoDimensions.height <= videoFormat.dimensions.height && minFps <= videoFormat.framerate;
            if (maxVideoDimensions.width > 0) {
                formatCompatible &= maxVideoDimensions.width >= videoFormat.dimensions.width;
            }
            if (maxVideoDimensions.height > 0) {
                formatCompatible &= maxVideoDimensions.height >= videoFormat.dimensions.height;
            }
            if (maxFps > 0) {
                formatCompatible &= maxFps >= videoFormat.framerate;
            }
            if (aspectRatio.numerator > 0 && aspectRatio.denominator > 0) {
                double ratio = (double)videoFormat.dimensions.width / (double)videoFormat.dimensions.height;
                double targetRatio = (double)aspectRatio.numerator / (double)aspectRatio.denominator;
                formatCompatible &= Math.abs(ratio - targetRatio) < 0.05;
            }
            if (!formatCompatible) continue;
            logger.i("VideoConstraints are compatible with VideoCapturer");
            return true;
        }
        logger.e("VideoConstraints are not compatible with VideoCapturer");
        return false;
    }

    private VideoConstraints getClosestCompatibleVideoConstraints(VideoCapturer videoCapturer, final VideoConstraints videoConstraints) {
        List<VideoFormat> supportedFormats = videoCapturer.getSupportedFormats();
        VideoDimensions closestSupportedVideoDimensions = Collections.min(supportedFormats, new ClosestComparator<VideoFormat>(){

            @Override
            int diff(VideoFormat videoFormat) {
                return Math.abs(videoConstraints.getMaxVideoDimensions().width - videoFormat.dimensions.width) + Math.abs(videoConstraints.getMaxVideoDimensions().height - videoFormat.dimensions.height);
            }
        }).dimensions;
        ArrayList<Integer> supportedFramerates = new ArrayList<Integer>();
        for (VideoFormat videoFormat : supportedFormats) {
            if (!videoFormat.dimensions.equals(closestSupportedVideoDimensions)) continue;
            supportedFramerates.add(videoFormat.framerate);
        }
        int closestSupportedFramerate = Collections.min(supportedFramerates, new ClosestComparator<Integer>(){

            @Override
            int diff(Integer framerate) {
                return Math.abs(videoConstraints.getMaxFps() - framerate);
            }
        });
        return new VideoConstraints.Builder().maxFps(closestSupportedFramerate).maxVideoDimensions(closestSupportedVideoDimensions).build();
    }

    long getNativeLocalMediaHandle() {
        return this.nativeLocalMediaHandle;
    }

    private void checkReleased(String methodName) {
        if (this.nativeLocalMediaHandle == 0L) {
            String releaseErrorMessage = String.format(RELEASE_MESSAGE_TEMPLATE, methodName);
            throw new IllegalStateException(releaseErrorMessage);
        }
    }

    private void checkSupportedFormats(VideoCapturer videoCapturer) {
        if (videoCapturer.getSupportedFormats() == null || videoCapturer.getSupportedFormats().isEmpty()) {
            throw new IllegalStateException("A VideoCapturer must provide at least one supported VideoFormat");
        }
    }

    private native LocalAudioTrack nativeAddAudioTrack(long var1, boolean var3, AudioOptions var4);

    private native boolean nativeRemoveAudioTrack(long var1, String var3);

    private native LocalVideoTrack nativeAddVideoTrack(long var1, boolean var3, VideoCapturer var4, VideoConstraints var5, EglBase.Context var6);

    private native boolean nativeRemoveVideoTrack(long var1, String var3);

    private native void nativeRelease(long var1);

    private static abstract class ClosestComparator<T>
    implements Comparator<T> {
        private ClosestComparator() {
        }

        abstract int diff(T var1);

        @Override
        public int compare(T t1, T t2) {
            return this.diff(t1) - this.diff(t2);
        }
    }
}

