/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twilsock.util;

import android.content.Context;
import android.net.ConnectivityManager;
import com.twilio.util.ApplicationContextHolder;
import com.twilio.util.TwilioLoggerKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0006\u0010\u0017\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/twilio/twilsock/util/ProxyInfo;", "", "()V", "applicationContext", "Landroid/content/Context;", "<set-?>", "", "host", "getHost", "()Ljava/lang/String;", "password", "getPassword", "", "port", "getPort", "()I", "user", "getUser", "parseHostParts", "", "proxy", "readProxyConfigFromFile", "readProxyConfigFromSystem", "update", "twilsock_release"})
@SourceDebugExtension(value={"SMAP\nProxyInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyInfo.kt\ncom/twilio/twilsock/util/ProxyInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class ProxyInfo {
    @NotNull
    private final Context applicationContext = ApplicationContextHolder.getApplicationContext();
    @Nullable
    private String host;
    private int port = -1;
    @Nullable
    private String user;
    @Nullable
    private String password;

    public ProxyInfo() {
        this.update();
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final void update() {
        try {
            this.readProxyConfigFromFile();
            return;
        }
        catch (Exception e) {
            TwilioLoggerKt.getLogger((Object)this).i("Cannot read proxy config from file: ", (Throwable)e);
            try {
                this.readProxyConfigFromSystem();
            }
            catch (Exception e2) {
                TwilioLoggerKt.getLogger((Object)this).i("Cannot read proxy config from system: ", (Throwable)e2);
            }
            return;
        }
    }

    private final void readProxyConfigFromSystem() throws Exception {
        Method m = ConnectivityManager.class.getMethod("getDefaultProxy", new Class[0]);
        Object object = this.applicationContext.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager manager = (ConnectivityManager)object;
        Object object2 = m.invoke((Object)manager, new Object[0]);
        android.net.ProxyInfo proxyInfo = object2 instanceof android.net.ProxyInfo ? (android.net.ProxyInfo)object2 : null;
        if (proxyInfo == null) {
            return;
        }
        android.net.ProxyInfo proxy = proxyInfo;
        this.parseHostParts(proxy.getHost());
        this.port = proxy.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readProxyConfigFromFile() throws Exception {
        Closeable closeable = this.applicationContext.getAssets().open("proxysettings.properties");
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            Properties props = new Properties();
            props.load(reader);
            this.parseHostParts(props.getProperty("host", null));
            String string = props.getProperty("port", String.valueOf(this.port));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"props.getProperty(\"port\", port.toString())");
            this.port = Integer.parseInt(string);
            this.user = props.getProperty("user", this.user);
            this.password = props.getProperty("password", this.password);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void parseHostParts(String proxy) {
        block3: {
            Object it;
            List list;
            Object object;
            List list2;
            this.host = proxy;
            String string = this.host;
            if (string != null && (list2 = StringsKt.split$default((CharSequence)string, (char[])(object = new char[]{'@'}), (boolean)false, (int)0, (int)6, null)) != null) {
                list = list2;
                it = list;
                boolean bl = false;
                object = it.size() >= 2 ? list : null;
                if (object != null) {
                    it = object;
                    boolean bl2 = false;
                    this.user = (String)it.get(0);
                    this.host = (String)it.get(1);
                }
            }
            string = this.user;
            if (string == null || (list2 = StringsKt.split$default((CharSequence)string, (char[])(object = new char[]{':'}), (boolean)false, (int)0, (int)6, null)) == null) break block3;
            list = list2;
            it = list;
            boolean bl = false;
            object = it.size() >= 2 ? list : null;
            if (object != null) {
                it = object;
                boolean bl3 = false;
                this.user = (String)it.get(0);
                this.password = (String)it.get(1);
            }
        }
    }
}

