/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twilsock.client;

import com.neovisionaries.ws.client.ProxySettings;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import com.twilio.twilsock.client.TwilsockTransport;
import com.twilio.twilsock.client.TwilsockTransportListener;
import com.twilio.twilsock.util.ProxyInfo;
import com.twilio.twilsock.util.SslContextKt;
import com.twilio.util.ErrorInfo;
import com.twilio.util.ErrorReason;
import com.twilio.util.TwilioLogger;
import com.twilio.util.TwilioLoggerKt;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001(B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\bJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J<\u0010\u001e\u001a\u00020\u00152)\b\u0004\u0010\u001f\u001a#\b\u0001\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150!\u0012\u0006\u0012\u0004\u0018\u00010\u00010 \u00a2\u0006\u0002\b\"H\u0082\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lcom/twilio/twilsock/client/TwilsockTransport;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "connectTimeout", "Lkotlin/time/Duration;", "certificates", "", "", "listener", "Lcom/twilio/twilsock/client/TwilsockTransportListener;", "(Lkotlinx/coroutines/CoroutineScope;JLjava/util/List;Lcom/twilio/twilsock/client/TwilsockTransportListener;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "mState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/twilio/twilsock/client/TwilsockTransport$State;", "kotlin.jvm.PlatformType", "webSocket", "Lcom/neovisionaries/ws/client/WebSocket;", "webSocketFactory", "Lcom/neovisionaries/ws/client/WebSocketFactory;", "connect", "", "url", "useProxy", "", "disconnect", "reason", "doDisconnect", "errorInfo", "Lcom/twilio/util/ErrorInfo;", "notifyListener", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)V", "sendMessage", "bytes", "", "setupProxy", "State", "twilsock_release"})
@SourceDebugExtension(value={"SMAP\nTwilsockTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwilsockTransport.kt\ncom/twilio/twilsock/client/TwilsockTransport\n+ 2 TwilioLogger.kt\ncom/twilio/util/TwilioLogger\n*L\n1#1,173:1\n158#1,4:179\n99#2,5:174\n*S KotlinDebug\n*F\n+ 1 TwilsockTransport.kt\ncom/twilio/twilsock/client/TwilsockTransport\n*L\n132#1:179,4\n119#1:174,5\n*E\n"})
public final class TwilsockTransport {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final TwilsockTransportListener listener;
    @NotNull
    private final AtomicReference<State> mState;
    @NotNull
    private final WebSocketFactory webSocketFactory;
    @Nullable
    private WebSocket webSocket;

    private TwilsockTransport(CoroutineScope coroutineScope, long connectTimeout, List<String> certificates, TwilsockTransportListener listener) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.coroutineScope = coroutineScope;
        this.listener = listener;
        this.mState = new AtomicReference<State>(State.DISCONNECTED);
        this.webSocketFactory = new WebSocketFactory();
        this.webSocketFactory.setConnectionTimeout((int)Duration.getInWholeMilliseconds-impl((long)connectTimeout));
        this.webSocketFactory.setSSLContext(SslContextKt.SslContext(certificates));
        TwilioLogger.i$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)("constructed connectionTimeout: " + this.webSocketFactory.getConnectionTimeout()), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void connect(@NotNull String url, boolean useProxy) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        TwilioLogger.i$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)("connect: " + url), null, (int)2, null);
        if (!this.mState.compareAndSet(State.DISCONNECTED, State.CONNECTING)) {
            TwilioLogger.w$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)("cannot connect in state" + (Object)((Object)this.mState.get()) + ". Ignored."), null, (int)2, null);
            return;
        }
        try {
            void $this$connect_u24lambda_u240;
            WebSocket webSocket;
            this.setupProxy(useProxy);
            WebSocket webSocket2 = webSocket = this.webSocketFactory.createSocket(url);
            TwilsockTransport twilsockTransport = this;
            boolean bl = false;
            $this$connect_u24lambda_u240.addExtension("permessage-deflate");
            $this$connect_u24lambda_u240.setMissingCloseFrameAllowed(true);
            $this$connect_u24lambda_u240.addListener((WebSocketListener)new WebSocketAdapter(this){
                final /* synthetic */ TwilsockTransport this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onConnected(@NotNull WebSocket websocket, @Nullable Map<String, ? extends List<String>> headers) {
                    Intrinsics.checkNotNullParameter((Object)websocket, (String)"websocket");
                    super.onConnected(websocket, headers);
                    State prevState = TwilsockTransport.access$getMState$p(this.this$0).getAndSet(State.CONNECTED);
                    TwilioLogger.i$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)((Object)this)), (String)("Connected: " + (Object)((Object)prevState)), null, (int)2, null);
                    if (prevState != State.CONNECTED) {
                        TwilsockTransport this_$iv = this.this$0;
                        boolean $i$f$notifyListener = false;
                        BuildersKt.launch$default((CoroutineScope)TwilsockTransport.access$getCoroutineScope$p(this_$iv), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this_$iv, null){
                            int label;
                            final /* synthetic */ TwilsockTransport this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Continuation cfr_ignored_0 = (Continuation)this;
                                        TwilsockTransportListener $this$onConnected_u24lambda_u240 = TwilsockTransport.access$getListener$p(this.this$0);
                                        boolean bl = false;
                                        $this$onConnected_u24lambda_u240.onTransportConnected();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }

                public void onConnectError(@NotNull WebSocket websocket, @Nullable WebSocketException exception) {
                    ErrorInfo errorInfo;
                    Intrinsics.checkNotNullParameter((Object)websocket, (String)"websocket");
                    super.onConnectError(websocket, exception);
                    TwilioLoggerKt.getLogger((Object)((Object)this)).e("onConnectError: ", (Throwable)exception);
                    WebSocketException webSocketException = exception;
                    Object object = webSocketException != null ? webSocketException.getError() : null;
                    switch (object == null ? -1 : connect.1.WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
                        case 1: {
                            errorInfo = new ErrorInfo(ErrorReason.HostnameUnverified, 0, 0, null, null, 30, null);
                            break;
                        }
                        case 2: {
                            errorInfo = new ErrorInfo(ErrorReason.SslHandshakeError, 0, 0, null, null, 30, null);
                            break;
                        }
                        default: {
                            errorInfo = new ErrorInfo(ErrorReason.Unknown, 0, 0, "Failed to connect", null, 22, null);
                        }
                    }
                    ErrorInfo errorInfo2 = errorInfo;
                    TwilsockTransport.access$doDisconnect(this.this$0, errorInfo2);
                }

                public void onDisconnected(@NotNull WebSocket websocket, @Nullable WebSocketFrame serverCloseFrame, @Nullable WebSocketFrame clientCloseFrame, boolean closedByServer) {
                    Intrinsics.checkNotNullParameter((Object)websocket, (String)"websocket");
                    super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
                    TwilioLogger.i$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)((Object)this)), (String)("onDisconnected: by server=" + closedByServer + "\nserverCloseFrame: " + serverCloseFrame + "\nclientCloseFrame: " + clientCloseFrame), null, (int)2, null);
                    TwilsockTransport.access$doDisconnect(this.this$0, new ErrorInfo(ErrorReason.TransportDisconnected, 0, 0, "onDisconnected: by server=" + closedByServer, null, 22, null));
                }

                public void onBinaryMessage(@NotNull WebSocket websocket, @NotNull byte[] binary) {
                    Intrinsics.checkNotNullParameter((Object)websocket, (String)"websocket");
                    Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
                    super.onBinaryMessage(websocket, binary);
                    TwilioLogger $this$iv = TwilioLoggerKt.getLogger((Object)((Object)this));
                    Throwable t$iv = null;
                    boolean $i$f$v = false;
                    if ($this$iv.isVerboseEnabled()) {
                        TwilioLogger twilioLogger = $this$iv;
                        boolean bl = false;
                        twilioLogger.v("onBinaryMessage: " + StringsKt.decodeToString((byte[])binary), t$iv);
                    }
                    TwilsockTransport.access$getListener$p(this.this$0).onMessageReceived(binary);
                }
            });
            twilsockTransport.webSocket = webSocket;
            WebSocket webSocket3 = this.webSocket;
            Intrinsics.checkNotNull((Object)webSocket3);
            webSocket3.connectAsynchronously();
        }
        catch (Throwable t) {
            TwilioLoggerKt.getLogger((Object)this).e("Error in connect: ", t);
            this.doDisconnect(new ErrorInfo(ErrorReason.Unknown, 0, 0, "Error in connect: " + ExceptionsKt.stackTraceToString((Throwable)t), null, 22, null));
        }
    }

    public static /* synthetic */ void connect$default(TwilsockTransport twilsockTransport, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        twilsockTransport.connect(string, bl);
    }

    public final void sendMessage(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        WebSocket webSocket = this.webSocket;
        if ((webSocket != null ? webSocket.sendBinary(bytes) : null) == null) {
            throw new IllegalStateException("TwilsockTransport is not ready. Call connect() first".toString());
        }
        TwilioLogger $this$iv = TwilioLoggerKt.getLogger((Object)this);
        Throwable t$iv = null;
        boolean $i$f$v = false;
        if ($this$iv.isVerboseEnabled()) {
            TwilioLogger twilioLogger = $this$iv;
            boolean bl = false;
            twilioLogger.v("sendMessage: " + StringsKt.decodeToString((byte[])bytes), t$iv);
        }
    }

    public final void disconnect(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.doDisconnect(new ErrorInfo(ErrorReason.TransportDisconnected, 0, 0, "Disconnect called: " + reason, null, 22, null));
    }

    private final synchronized void doDisconnect(ErrorInfo errorInfo) {
        State prevState = this.mState.getAndSet(State.DISCONNECTED);
        TwilioLogger.i$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)("doDisconnect(" + errorInfo + "): " + (Object)((Object)prevState)), null, (int)2, null);
        if (prevState != State.DISCONNECTED) {
            WebSocket webSocket = this.webSocket;
            if (webSocket != null) {
                webSocket.disconnect(1000);
            }
            TwilsockTransport this_$iv = this;
            boolean $i$f$notifyListener = false;
            BuildersKt.launch$default((CoroutineScope)this_$iv.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this_$iv, null, errorInfo){
                int label;
                final /* synthetic */ TwilsockTransport this$0;
                final /* synthetic */ ErrorInfo $errorInfo$inlined;
                {
                    this.this$0 = $receiver;
                    this.$errorInfo$inlined = errorInfo;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Continuation cfr_ignored_0 = (Continuation)this;
                            TwilsockTransportListener $this$doDisconnect_u24lambda_u242 = TwilsockTransport.access$getListener$p(this.this$0);
                            boolean bl = false;
                            $this$doDisconnect_u24lambda_u242.onTransportDisconnected(this.$errorInfo$inlined);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void setupProxy(boolean useProxy) {
        ProxySettings proxySettings = this.webSocketFactory.getProxySettings();
        proxySettings.reset();
        if (!useProxy) {
            return;
        }
        ProxyInfo proxyInfo = new ProxyInfo();
        if (proxyInfo.getHost() == null) {
            TwilioLogger.i$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)"Proxy info is not set", null, (int)2, null);
            return;
        }
        TwilioLogger.i$default((TwilioLogger)TwilioLoggerKt.getLogger((Object)this), (String)("Using proxy: " + proxyInfo.getHost() + ':' + proxyInfo.getPort()), null, (int)2, null);
        proxySettings.setHost(proxyInfo.getHost()).setPort(proxyInfo.getPort()).setCredentials(proxyInfo.getUser(), proxyInfo.getPassword());
    }

    private final void notifyListener(Function2<? super TwilsockTransportListener, ? super Continuation<? super Unit>, ? extends Object> block) {
        boolean $i$f$notifyListener = false;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(block, this, null){
            int label;
            final /* synthetic */ Function2<TwilsockTransportListener, Continuation<? super Unit>, Object> $block;
            final /* synthetic */ TwilsockTransport this$0;
            {
                this.$block = $block;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$block.invoke((Object)TwilsockTransport.access$getListener$p(this.this$0), (Object)((Object)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invokeSuspend$$forInline(@NotNull Object $result) {
                this.$block.invoke((Object)TwilsockTransport.access$getListener$p(this.this$0), (Object)((Object)this));
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ TwilsockTransport(CoroutineScope coroutineScope, long connectTimeout, List certificates, TwilsockTransportListener listener, DefaultConstructorMarker $constructor_marker) {
        this(coroutineScope, connectTimeout, certificates, listener);
    }

    public static final /* synthetic */ TwilsockTransportListener access$getListener$p(TwilsockTransport $this) {
        return $this.listener;
    }

    public static final /* synthetic */ AtomicReference access$getMState$p(TwilsockTransport $this) {
        return $this.mState;
    }

    public static final /* synthetic */ void access$doDisconnect(TwilsockTransport $this, ErrorInfo errorInfo) {
        $this.doDisconnect(errorInfo);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/twilio/twilsock/client/TwilsockTransport$State;", "", "(Ljava/lang/String;I)V", "DISCONNECTED", "CONNECTING", "CONNECTED", "twilsock_release"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State DISCONNECTED = new State();
        public static final /* enum */ State CONNECTING = new State();
        public static final /* enum */ State CONNECTED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.DISCONNECTED, State.CONNECTING, State.CONNECTED};
        }
    }
}

