/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKeys;
import com.twilio.util.ApplicationContextHolder;
import com.twilio.util.TwilioLogger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007\u00b2\u0006\u0012\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00010\u0001X\u008a\u0084\u0002"}, d2={"sharedPreferences", "Landroid/content/SharedPreferences;", "sharedPreferencesFactory", "stringPreference", "Lkotlin/properties/ReadWriteProperty;", "", "", "shared-internal_release", "regularPreferences", "kotlin.jvm.PlatformType"})
public final class PreferencesKt {
    @NotNull
    private static final SharedPreferences sharedPreferences = PreferencesKt.sharedPreferencesFactory();

    private static final SharedPreferences sharedPreferencesFactory() {
        Context context = ApplicationContextHolder.getApplicationContext();
        Lazy regularPreferences$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            public final SharedPreferences invoke() {
                return this.$context.getSharedPreferences("TwilioPreferencesPre23", 0);
            }
        }));
        if (Build.VERSION.SDK_INT < 23) {
            SharedPreferences sharedPreferences = PreferencesKt.sharedPreferencesFactory$lambda$0((Lazy<? extends SharedPreferences>)regularPreferences$delegate);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"regularPreferences");
            return sharedPreferences;
        }
        try {
            SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((String)"TwilioPreferences", (String)MasterKeys.getOrCreate((KeyGenParameterSpec)MasterKeys.AES256_GCM_SPEC), (Context)context, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n            \"Twi\u2026heme.AES256_GCM\n        )");
            return sharedPreferences;
        }
        catch (Throwable t) {
            TwilioLogger logger2 = TwilioLogger.Companion.getLogger("sharedPreferencesFactory");
            logger2.w("Error creating EncryptedSharedPreferences, falling back to regular SharedPreferences", t);
            SharedPreferences sharedPreferences = PreferencesKt.sharedPreferencesFactory$lambda$0((Lazy<? extends SharedPreferences>)regularPreferences$delegate);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"regularPreferences");
            return sharedPreferences;
        }
    }

    @NotNull
    public static final ReadWriteProperty<Object, String> stringPreference() {
        return (ReadWriteProperty)new ReadWriteProperty<Object, String>(){

            @NotNull
            public String getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                String string = PreferencesKt.access$getSharedPreferences$p().getString(property.getName(), "");
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            public void setValue(@Nullable Object thisRef, @NotNull KProperty<?> property, @NotNull String value) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                PreferencesKt.access$getSharedPreferences$p().edit().putString(property.getName(), value).apply();
            }
        };
    }

    private static final SharedPreferences sharedPreferencesFactory$lambda$0(Lazy<? extends SharedPreferences> $regularPreferences$delegate) {
        Lazy<? extends SharedPreferences> lazy = $regularPreferences$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    public static final /* synthetic */ SharedPreferences access$getSharedPreferences$p() {
        return sharedPreferences;
    }
}

