/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.taskrouter.FilterRequirement;
import java.util.HashMap;
import java.util.Map;

public class Policy {
    private final String url;
    private final String method;
    private Map<String, FilterRequirement> queryFilter;
    private Map<String, FilterRequirement> postFilter;
    private final boolean allowed;

    public Policy(String url, String method, Map<String, FilterRequirement> queryFilter, Map<String, FilterRequirement> postFilter, boolean allowed) {
        this.url = url;
        this.method = method;
        this.queryFilter = queryFilter;
        this.postFilter = postFilter;
        this.allowed = allowed;
    }

    public Policy(String url, String method, boolean allowed) {
        this(url, method, new HashMap<String, FilterRequirement>(), new HashMap<String, FilterRequirement>(), allowed);
    }

    public Policy addQueryFilterParam(String name, FilterRequirement required) {
        this.queryFilter.put(name, required);
        return this;
    }

    public Policy addPostFilterParam(String name, FilterRequirement required) {
        this.postFilter.put(name, required);
        return this;
    }

    public Policy setQueryFilter(Map<String, FilterRequirement> queryFilter) {
        this.queryFilter = queryFilter;
        return this;
    }

    public Policy setPostFilter(Map<String, FilterRequirement> postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    public String toJSONString() throws JsonProcessingException {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("url", this.url);
        obj.put("method", this.method);
        obj.put("allow", this.allowed);
        HashMap<String, FilterRequirement> query = new HashMap<String, FilterRequirement>();
        HashMap<String, FilterRequirement> post = new HashMap<String, FilterRequirement>();
        if (this.queryFilter != null) {
            for (Map.Entry<String, FilterRequirement> e : this.queryFilter.entrySet()) {
                query.put(e.getKey(), e.getValue());
            }
        }
        if (this.postFilter != null) {
            for (Map.Entry<String, FilterRequirement> e : this.postFilter.entrySet()) {
                post.put(e.getKey(), e.getValue());
            }
        }
        obj.put("query_filter", query);
        obj.put("post_filter", post);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(obj);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("url", (Object)this.url).add("method", (Object)this.method).add("queryFilter", this.queryFilter).add("postFilter", this.postFilter).add("allowed", this.allowed).toString();
    }
}

