/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.Activity;
import com.twilio.sdk.updater.Updater;

public class ActivityUpdater
extends Updater<Activity> {
    private final String workspaceSid;
    private final String sid;
    private final String friendlyName;

    public ActivityUpdater(String workspaceSid, String sid, String friendlyName) {
        this.workspaceSid = workspaceSid;
        this.sid = sid;
        this.friendlyName = friendlyName;
    }

    @Override
    public Activity execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Activities/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Activity update failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Activity.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

