/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.ipmessaging.v1;

import com.fasterxml.jackson.databind.JsonNode;
import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.ipmessaging.v1.Service;
import com.twilio.sdk.updater.Updater;

public class ServiceUpdater
extends Updater<Service> {
    private final String sid;
    private String friendlyName;
    private String defaultServiceRoleSid;
    private String defaultChannelRoleSid;
    private String defaultChannelCreatorRoleSid;
    private Boolean readStatusEnabled;
    private Integer typingIndicatorTimeout;
    private Integer consumptionReportInterval;
    private JsonNode webhooks;

    public ServiceUpdater(String sid) {
        this.sid = sid;
    }

    public ServiceUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ServiceUpdater setDefaultServiceRoleSid(String defaultServiceRoleSid) {
        this.defaultServiceRoleSid = defaultServiceRoleSid;
        return this;
    }

    public ServiceUpdater setDefaultChannelRoleSid(String defaultChannelRoleSid) {
        this.defaultChannelRoleSid = defaultChannelRoleSid;
        return this;
    }

    public ServiceUpdater setDefaultChannelCreatorRoleSid(String defaultChannelCreatorRoleSid) {
        this.defaultChannelCreatorRoleSid = defaultChannelCreatorRoleSid;
        return this;
    }

    public ServiceUpdater setReadStatusEnabled(Boolean readStatusEnabled) {
        this.readStatusEnabled = readStatusEnabled;
        return this;
    }

    public ServiceUpdater setTypingIndicatorTimeout(Integer typingIndicatorTimeout) {
        this.typingIndicatorTimeout = typingIndicatorTimeout;
        return this;
    }

    public ServiceUpdater setConsumptionReportInterval(Integer consumptionReportInterval) {
        this.consumptionReportInterval = consumptionReportInterval;
        return this;
    }

    public ServiceUpdater setWebhooks(JsonNode webhooks) {
        this.webhooks = webhooks;
        return this;
    }

    @Override
    public Service execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.IPMESSAGING, "/v1/Services/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.defaultServiceRoleSid != null) {
            request.addPostParam("DefaultServiceRoleSid", this.defaultServiceRoleSid);
        }
        if (this.defaultChannelRoleSid != null) {
            request.addPostParam("DefaultChannelRoleSid", this.defaultChannelRoleSid);
        }
        if (this.defaultChannelCreatorRoleSid != null) {
            request.addPostParam("DefaultChannelCreatorRoleSid", this.defaultChannelCreatorRoleSid);
        }
        if (this.readStatusEnabled != null) {
            request.addPostParam("ReadStatusEnabled", this.readStatusEnabled.toString());
        }
        if (this.typingIndicatorTimeout != null) {
            request.addPostParam("TypingIndicatorTimeout", this.typingIndicatorTimeout.toString());
        }
        if (this.consumptionReportInterval != null) {
            request.addPostParam("ConsumptionReportInterval", this.consumptionReportInterval.toString());
        }
        if (this.webhooks != null) {
            request.addPostParam("Webhooks", this.webhooks.toString());
        }
    }
}

