/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.taskrouter.v1.workspace.TaskCreator;
import com.twilio.sdk.deleter.taskrouter.v1.workspace.TaskDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.taskrouter.v1.workspace.TaskFetcher;
import com.twilio.sdk.reader.taskrouter.v1.workspace.TaskReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.taskrouter.v1.workspace.TaskUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Task
extends SidResource {
    private static final long serialVersionUID = 85239715418365L;
    private final String accountSid;
    private final Integer age;
    private final Status assignmentStatus;
    private final String attributes;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Integer priority;
    private final String reason;
    private final String sid;
    private final String taskQueueSid;
    private final Integer timeout;
    private final String workflowSid;
    private final String workspaceSid;

    public static TaskFetcher fetch(String workspaceSid, String sid) {
        return new TaskFetcher(workspaceSid, sid);
    }

    public static TaskUpdater update(String workspaceSid, String sid) {
        return new TaskUpdater(workspaceSid, sid);
    }

    public static TaskDeleter delete(String workspaceSid, String sid) {
        return new TaskDeleter(workspaceSid, sid);
    }

    public static TaskReader read(String workspaceSid) {
        return new TaskReader(workspaceSid);
    }

    public static TaskCreator create(String workspaceSid, String attributes, String workflowSid) {
        return new TaskCreator(workspaceSid, attributes, workflowSid);
    }

    public static Task fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Task)objectMapper.readValue(json, Task.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Task fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Task)objectMapper.readValue(json, Task.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Task(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="age") Integer age, @JsonProperty(value="assignment_status") Status assignmentStatus, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="reason") String reason, @JsonProperty(value="sid") String sid, @JsonProperty(value="task_queue_sid") String taskQueueSid, @JsonProperty(value="timeout") Integer timeout, @JsonProperty(value="workflow_sid") String workflowSid, @JsonProperty(value="workspace_sid") String workspaceSid) {
        this.accountSid = accountSid;
        this.age = age;
        this.assignmentStatus = assignmentStatus;
        this.attributes = attributes;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.priority = priority;
        this.reason = reason;
        this.sid = sid;
        this.taskQueueSid = taskQueueSid;
        this.timeout = timeout;
        this.workflowSid = workflowSid;
        this.workspaceSid = workspaceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getAge() {
        return this.age;
    }

    public final Status getAssignmentStatus() {
        return this.assignmentStatus;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    public final String getReason() {
        return this.reason;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getTaskQueueSid() {
        return this.taskQueueSid;
    }

    public final Integer getTimeout() {
        return this.timeout;
    }

    public final String getWorkflowSid() {
        return this.workflowSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task other = (Task)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.age, other.age) && Objects.equals((Object)this.assignmentStatus, (Object)other.assignmentStatus) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.priority, other.priority) && Objects.equals(this.reason, other.reason) && Objects.equals(this.sid, other.sid) && Objects.equals(this.taskQueueSid, other.taskQueueSid) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.workflowSid, other.workflowSid) && Objects.equals(this.workspaceSid, other.workspaceSid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.age, this.assignmentStatus, this.attributes, this.dateCreated, this.dateUpdated, this.priority, this.reason, this.sid, this.taskQueueSid, this.timeout, this.workflowSid, this.workspaceSid});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("age", (Object)this.age).add("assignmentStatus", (Object)this.assignmentStatus).add("attributes", (Object)this.attributes).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("priority", (Object)this.priority).add("reason", (Object)this.reason).add("sid", (Object)this.sid).add("taskQueueSid", (Object)this.taskQueueSid).add("timeout", (Object)this.timeout).add("workflowSid", (Object)this.workflowSid).add("workspaceSid", (Object)this.workspaceSid).toString();
    }

    public static enum Status {
        PENDING("pending"),
        RESERVED("reserved"),
        ASSIGNED("assigned"),
        CANCELED("canceled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Status.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

