/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.pricing.v1.phonenumber;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.CurrencyDeserializer;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.pricing.v1.phonenumber.CountryFetcher;
import com.twilio.sdk.reader.pricing.v1.phonenumber.CountryReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.type.PhoneNumberPrice;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Currency;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Country
extends SidResource {
    private static final long serialVersionUID = 157533851169375L;
    private final String country;
    private final String isoCountry;
    private final List<PhoneNumberPrice> phoneNumberPrices;
    private final Currency priceUnit;
    private final URI uri;
    private final URI url;

    public static CountryReader read() {
        return new CountryReader();
    }

    public static CountryFetcher fetch(String isoCountry) {
        return new CountryFetcher(isoCountry);
    }

    public static Country fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Country)objectMapper.readValue(json, Country.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Country fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Country)objectMapper.readValue(json, Country.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Country(@JsonProperty(value="country") String country, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="phone_number_prices") List<PhoneNumberPrice> phoneNumberPrices, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="uri") URI uri, @JsonProperty(value="url") URI url) {
        this.country = country;
        this.isoCountry = isoCountry;
        this.phoneNumberPrices = phoneNumberPrices;
        this.priceUnit = priceUnit;
        this.uri = uri;
        this.url = url;
    }

    @Override
    public final String getSid() {
        return this.getIsoCountry();
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final List<PhoneNumberPrice> getPhoneNumberPrices() {
        return this.phoneNumberPrices;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Country other = (Country)o;
        return Objects.equals(this.country, other.country) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.phoneNumberPrices, other.phoneNumberPrices) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.uri, other.uri) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.country, this.isoCountry, this.phoneNumberPrices, this.priceUnit, this.uri, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("country", (Object)this.country).add("isoCountry", (Object)this.isoCountry).add("phoneNumberPrices", this.phoneNumberPrices).add("priceUnit", (Object)this.priceUnit).add("uri", (Object)this.uri).add("url", (Object)this.url).toString();
    }
}

