/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.notifications.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.notifications.v1.service.NotificationCreator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Notification
extends Resource {
    private static final long serialVersionUID = 263880980114231L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final DateTime dateCreated;
    private final List<String> identities;
    private final List<String> tags;
    private final String priority;
    private final Integer ttl;
    private final String title;
    private final String body;
    private final String sound;
    private final String action;
    private final JsonNode data;
    private final JsonNode apn;
    private final JsonNode gcm;

    public static NotificationCreator create(String serviceSid) {
        return new NotificationCreator(serviceSid);
    }

    public static Notification fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Notification)objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Notification fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Notification)objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Notification(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="identities") List<String> identities, @JsonProperty(value="tags") List<String> tags, @JsonProperty(value="priority") String priority, @JsonProperty(value="ttl") Integer ttl, @JsonProperty(value="title") String title, @JsonProperty(value="body") String body, @JsonProperty(value="sound") String sound, @JsonProperty(value="action") String action, @JsonProperty(value="data") JsonNode data, @JsonProperty(value="apn") JsonNode apn, @JsonProperty(value="gcm") JsonNode gcm) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.identities = identities;
        this.tags = tags;
        this.priority = priority;
        this.ttl = ttl;
        this.title = title;
        this.body = body;
        this.sound = sound;
        this.action = action;
        this.data = data;
        this.apn = apn;
        this.gcm = gcm;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final List<String> getIdentities() {
        return this.identities;
    }

    public final List<String> getTags() {
        return this.tags;
    }

    public final String getPriority() {
        return this.priority;
    }

    public final Integer getTtl() {
        return this.ttl;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getBody() {
        return this.body;
    }

    public final String getSound() {
        return this.sound;
    }

    public final String getAction() {
        return this.action;
    }

    public final JsonNode getData() {
        return this.data;
    }

    public final JsonNode getApn() {
        return this.apn;
    }

    public final JsonNode getGcm() {
        return this.gcm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification other = (Notification)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.identities, other.identities) && Objects.equals(this.tags, other.tags) && Objects.equals(this.priority, other.priority) && Objects.equals(this.ttl, other.ttl) && Objects.equals(this.title, other.title) && Objects.equals(this.body, other.body) && Objects.equals(this.sound, other.sound) && Objects.equals(this.action, other.action) && Objects.equals(this.data, other.data) && Objects.equals(this.apn, other.apn) && Objects.equals(this.gcm, other.gcm);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.identities, this.tags, this.priority, this.ttl, this.title, this.body, this.sound, this.action, this.data, this.apn, this.gcm);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("dateCreated", (Object)this.dateCreated).add("identities", this.identities).add("tags", this.tags).add("priority", (Object)this.priority).add("ttl", (Object)this.ttl).add("title", (Object)this.title).add("body", (Object)this.body).add("sound", (Object)this.sound).add("action", (Object)this.action).add("data", (Object)this.data).add("apn", (Object)this.apn).add("gcm", (Object)this.gcm).toString();
    }

    public static enum Priority {
        HIGH("high"),
        LOW("low");

        private final String value;

        private Priority(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Priority forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Priority.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

