/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.ipmessaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.ipmessaging.v1.ServiceCreator;
import com.twilio.sdk.deleter.ipmessaging.v1.ServiceDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.ipmessaging.v1.ServiceFetcher;
import com.twilio.sdk.reader.ipmessaging.v1.ServiceReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.ipmessaging.v1.ServiceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Service
extends SidResource {
    private static final long serialVersionUID = 232026251916691L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String defaultServiceRoleSid;
    private final String defaultChannelRoleSid;
    private final String defaultChannelCreatorRoleSid;
    private final Boolean readStatusEnabled;
    private final Integer typingIndicatorTimeout;
    private final Integer consumptionReportInterval;
    private final JsonNode webhooks;
    private final URI url;
    private final Map<String, String> links;

    public static ServiceFetcher fetch(String sid) {
        return new ServiceFetcher(sid);
    }

    public static ServiceDeleter delete(String sid) {
        return new ServiceDeleter(sid);
    }

    public static ServiceCreator create(String friendlyName) {
        return new ServiceCreator(friendlyName);
    }

    public static ServiceReader read() {
        return new ServiceReader();
    }

    public static ServiceUpdater update(String sid) {
        return new ServiceUpdater(sid);
    }

    public static Service fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Service)objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Service fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Service)objectMapper.readValue(json, Service.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Service(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="default_service_role_sid") String defaultServiceRoleSid, @JsonProperty(value="default_channel_role_sid") String defaultChannelRoleSid, @JsonProperty(value="default_channel_creator_role_sid") String defaultChannelCreatorRoleSid, @JsonProperty(value="read_status_enabled") Boolean readStatusEnabled, @JsonProperty(value="typing_indicator_timeout") Integer typingIndicatorTimeout, @JsonProperty(value="consumption_report_interval") Integer consumptionReportInterval, @JsonProperty(value="webhooks") JsonNode webhooks, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.defaultServiceRoleSid = defaultServiceRoleSid;
        this.defaultChannelRoleSid = defaultChannelRoleSid;
        this.defaultChannelCreatorRoleSid = defaultChannelCreatorRoleSid;
        this.readStatusEnabled = readStatusEnabled;
        this.typingIndicatorTimeout = typingIndicatorTimeout;
        this.consumptionReportInterval = consumptionReportInterval;
        this.webhooks = webhooks;
        this.url = url;
        this.links = links;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDefaultServiceRoleSid() {
        return this.defaultServiceRoleSid;
    }

    public final String getDefaultChannelRoleSid() {
        return this.defaultChannelRoleSid;
    }

    public final String getDefaultChannelCreatorRoleSid() {
        return this.defaultChannelCreatorRoleSid;
    }

    public final Boolean getReadStatusEnabled() {
        return this.readStatusEnabled;
    }

    public final Integer getTypingIndicatorTimeout() {
        return this.typingIndicatorTimeout;
    }

    public final Integer getConsumptionReportInterval() {
        return this.consumptionReportInterval;
    }

    public final JsonNode getWebhooks() {
        return this.webhooks;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service other = (Service)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.defaultServiceRoleSid, other.defaultServiceRoleSid) && Objects.equals(this.defaultChannelRoleSid, other.defaultChannelRoleSid) && Objects.equals(this.defaultChannelCreatorRoleSid, other.defaultChannelCreatorRoleSid) && Objects.equals(this.readStatusEnabled, other.readStatusEnabled) && Objects.equals(this.typingIndicatorTimeout, other.typingIndicatorTimeout) && Objects.equals(this.consumptionReportInterval, other.consumptionReportInterval) && Objects.equals(this.webhooks, other.webhooks) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.friendlyName, this.dateCreated, this.dateUpdated, this.defaultServiceRoleSid, this.defaultChannelRoleSid, this.defaultChannelCreatorRoleSid, this.readStatusEnabled, this.typingIndicatorTimeout, this.consumptionReportInterval, this.webhooks, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("defaultServiceRoleSid", (Object)this.defaultServiceRoleSid).add("defaultChannelRoleSid", (Object)this.defaultChannelRoleSid).add("defaultChannelCreatorRoleSid", (Object)this.defaultChannelCreatorRoleSid).add("readStatusEnabled", (Object)this.readStatusEnabled).add("typingIndicatorTimeout", (Object)this.typingIndicatorTimeout).add("consumptionReportInterval", (Object)this.consumptionReportInterval).add("webhooks", (Object)this.webhooks).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

