/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.deleter.api.v2010.account.message.MediaDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.message.MediaFetcher;
import com.twilio.sdk.reader.api.v2010.account.message.MediaReader;
import com.twilio.sdk.resource.SidResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Media
extends SidResource {
    private static final long serialVersionUID = 138990472819672L;
    private final String accountSid;
    private final String contentType;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String parentSid;
    private final String sid;
    private final String uri;

    public static MediaDeleter delete(String accountSid, String messageSid, String sid) {
        return new MediaDeleter(accountSid, messageSid, sid);
    }

    public static MediaFetcher fetch(String accountSid, String messageSid, String sid) {
        return new MediaFetcher(accountSid, messageSid, sid);
    }

    public static MediaReader read(String accountSid, String messageSid) {
        return new MediaReader(accountSid, messageSid);
    }

    public static Media fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Media)objectMapper.readValue(json, Media.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Media fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Media)objectMapper.readValue(json, Media.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Media(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="content_type") String contentType, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="parent_sid") String parentSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.contentType = contentType;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.parentSid = parentSid;
        this.sid = sid;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getParentSid() {
        return this.parentSid;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Media other = (Media)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.parentSid, other.parentSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.contentType, this.dateCreated, this.dateUpdated, this.parentSid, this.sid, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("contentType", (Object)this.contentType).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("parentSid", (Object)this.parentSid).add("sid", (Object)this.sid).add("uri", (Object)this.uri).toString();
    }
}

