/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.deleter.api.v2010.account.RecordingDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.RecordingFetcher;
import com.twilio.sdk.reader.api.v2010.account.RecordingReader;
import com.twilio.sdk.resource.SidResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Recording
extends SidResource {
    private static final long serialVersionUID = 232068402359085L;
    private final String accountSid;
    private final String apiVersion;
    private final String callSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String duration;
    private final String sid;
    private final String uri;

    public static RecordingFetcher fetch(String accountSid, String sid) {
        return new RecordingFetcher(accountSid, sid);
    }

    public static RecordingDeleter delete(String accountSid, String sid) {
        return new RecordingDeleter(accountSid, sid);
    }

    public static RecordingReader read(String accountSid) {
        return new RecordingReader(accountSid);
    }

    public static Recording fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Recording)objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Recording fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Recording)objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Recording(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="duration") String duration, @JsonProperty(value="sid") String sid, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.callSid = callSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.duration = duration;
        this.sid = sid;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDuration() {
        return this.duration;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recording other = (Recording)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.duration, other.duration) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.apiVersion, this.callSid, this.dateCreated, this.dateUpdated, this.duration, this.sid, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("apiVersion", (Object)this.apiVersion).add("callSid", (Object)this.callSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("duration", (Object)this.duration).add("sid", (Object)this.sid).add("uri", (Object)this.uri).toString();
    }
}

