/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.Conference;

public class ConferenceReader
extends Reader<Conference> {
    private final String accountSid;
    private String dateCreated;
    private String dateUpdated;
    private String friendlyName;
    private Conference.Status status;

    public ConferenceReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public ConferenceReader byDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ConferenceReader byDateUpdated(String dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ConferenceReader byFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ConferenceReader byStatus(Conference.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public ResourceSet<Conference> execute(TwilioRestClient client) {
        return new ResourceSet<Conference>(this, client, this.firstPage());
    }

    @Override
    public Page<Conference> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Conferences.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Conference> nextPage(Page<Conference> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Conference> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conference read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("conferences", response.getContent(), Conference.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.dateCreated != null) {
            request.addQueryParam("DateCreated", this.dateCreated);
        }
        if (this.dateUpdated != null) {
            request.addQueryParam("DateUpdated", this.dateUpdated);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

