/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader;

import com.google.common.util.concurrent.ListenableFuture;
import com.twilio.sdk.Twilio;
import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.Resource;
import com.twilio.sdk.resource.ResourceSet;
import java.util.concurrent.Callable;

public abstract class Reader<T extends Resource> {
    private int pageSize = 50;

    public ResourceSet<T> execute() {
        return this.execute(Twilio.getRestClient());
    }

    public abstract ResourceSet<T> execute(TwilioRestClient var1);

    public ListenableFuture<ResourceSet<T>> async() {
        return this.async(Twilio.getRestClient());
    }

    public ListenableFuture<ResourceSet<T>> async(final TwilioRestClient client) {
        return Twilio.getExecutorService().submit(new Callable<ResourceSet<T>>(){

            @Override
            public ResourceSet<T> call() {
                return Reader.this.execute(client);
            }
        });
    }

    public Page<T> firstPage() {
        return this.firstPage(Twilio.getRestClient());
    }

    public abstract Page<T> firstPage(TwilioRestClient var1);

    public Page<T> nextPage(Page<T> page) {
        return this.nextPage(page, Twilio.getRestClient());
    }

    public abstract Page<T> nextPage(Page<T> var1, TwilioRestClient var2);

    public int getPageSize() {
        return this.pageSize;
    }

    public Reader<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }
}

