/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.http;

import com.google.common.base.Joiner;
import com.google.common.collect.Range;
import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.exception.InvalidRequestException;
import com.twilio.sdk.http.HttpMethod;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;

public class Request {
    public static final String QUERY_STRING_DATE_FORMAT = "yyyy-MM-dd";
    private final HttpMethod method;
    private final String uri;
    private final Map<String, List<String>> queryParams;
    private final Map<String, List<String>> postParams;
    private String username;
    private String password;

    public Request(HttpMethod method, String uri, String accountSid) {
        this(method, TwilioRestClient.Domains.API, uri, accountSid);
    }

    public Request(HttpMethod method, TwilioRestClient.Domains domain, String uri, String accountSid) {
        this.method = method;
        this.uri = "https://" + domain.toString() + ".twilio.com" + uri;
        this.queryParams = new HashMap<String, List<String>>();
        this.postParams = new HashMap<String, List<String>>();
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getAuthString() {
        String credentials = this.username + ":" + this.password;
        try {
            String encoded = new Base64().encodeAsString(credentials.getBytes("ascii"));
            return "Basic " + encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("It must be possible to encode credentials as ascii", credentials, e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean requiresAuthentication() {
        return this.username != null || this.password != null;
    }

    public URL constructURL() {
        String params = this.encodeQueryParams();
        String stringUri = this.uri;
        if (params.length() > 0) {
            stringUri = stringUri + "?" + params;
        }
        try {
            URI uri = new URI(stringUri);
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            throw new ApiException("Bad URI: " + stringUri, e);
        }
        catch (MalformedURLException e) {
            throw new ApiException("Bad URL: " + stringUri, e);
        }
    }

    public void addQueryDateRange(String name, Range<DateTime> range) {
        String value;
        if (range.hasLowerBound()) {
            value = ((DateTime)range.lowerEndpoint()).toString(QUERY_STRING_DATE_FORMAT);
            this.addQueryParam(name + ">", value);
        }
        if (range.hasUpperBound()) {
            value = ((DateTime)range.upperEndpoint()).toString(QUERY_STRING_DATE_FORMAT);
            this.addQueryParam(name + "<", value);
        }
    }

    public void addQueryParam(String name, String value) {
        this.addParam(this.queryParams, name, value);
    }

    public void addPostParam(String name, String value) {
        this.addParam(this.postParams, name, value);
    }

    private void addParam(Map<String, List<String>> params, String name, String value) {
        if (!params.containsKey(name)) {
            params.put(name, new ArrayList());
        }
        params.get(name).add(value);
    }

    public String encodeFormBody() {
        return Request.encodeParameters(this.postParams);
    }

    public String encodeQueryParams() {
        return Request.encodeParameters(this.queryParams);
    }

    private static String encodeParameters(Map<String, List<String>> params) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            try {
                String encodedName = URLEncoder.encode(entry.getKey(), "UTF-8");
                for (String value : entry.getValue()) {
                    String encodedValue = URLEncoder.encode(value, "UTF-8");
                    parameters.add(encodedName + "=" + encodedValue);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidRequestException("Couldn't encode params", entry.getKey(), e);
            }
        }
        return Joiner.on((String)"&").join(parameters);
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, List<String>> getPostParams() {
        return this.postParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request other = (Request)o;
        return Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.uri, other.uri) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals(this.queryParams, other.queryParams) && Objects.equals(this.postParams, other.postParams);
    }
}

