/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.pricing.v1.voice;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.pricing.v1.voice.Number;
import com.twilio.sdk.type.PhoneNumber;

public class NumberFetcher
extends Fetcher<Number> {
    private final PhoneNumber number;

    public NumberFetcher(PhoneNumber number) {
        this.number = number;
    }

    @Override
    public Number execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.PRICING, "/v1/Voice/Numbers/" + this.number + "", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Number fetch failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Number.fromJson(response.getStream(), client.getObjectMapper());
    }
}

