/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.lookups.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.lookups.v1.PhoneNumber;

public class PhoneNumberFetcher
extends Fetcher<PhoneNumber> {
    private final com.twilio.sdk.type.PhoneNumber phoneNumber;
    private String countryCode;
    private String type;

    public PhoneNumberFetcher(com.twilio.sdk.type.PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public PhoneNumberFetcher setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public PhoneNumberFetcher setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public PhoneNumber execute(TwilioRestClient client) {
        Response response;
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.LOOKUPS, "/v1/PhoneNumbers/" + this.phoneNumber + "", client.getAccountSid());
        if (this.countryCode != null) {
            request.addQueryParam("CountryCode", this.countryCode);
        }
        if (this.type != null) {
            request.addQueryParam("Type", this.type);
        }
        if ((response = client.request(request)) == null) {
            throw new ApiConnectionException("PhoneNumber fetch failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }
}

