/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.conversations.v1.conversation;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.conversations.v1.conversation.Participant;

public class ParticipantFetcher
extends Fetcher<Participant> {
    private final String conversationSid;
    private final String sid;

    public ParticipantFetcher(String conversationSid, String sid) {
        this.conversationSid = conversationSid;
        this.sid = sid;
    }

    @Override
    public Participant execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.CONVERSATIONS, "/v1/Conversations/" + this.conversationSid + "/Participants/" + this.sid + "", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant fetch failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }
}

