/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.deleter.api.v2010.account.sip;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.deleter.Deleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.sip.IpAccessControlList;

public class IpAccessControlListDeleter
extends Deleter<IpAccessControlList> {
    private final String accountSid;
    private final String sid;

    public IpAccessControlListDeleter(String accountSid, String sid) {
        this.accountSid = accountSid;
        this.sid = sid;
    }

    @Override
    public boolean execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/SIP/IpAccessControlLists/" + this.sid + ".json", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAccessControlList delete failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 204) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return true;
    }
}

