/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.taskrouter.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.Workspace;

public class WorkspaceCreator
extends Creator<Workspace> {
    private final String friendlyName;
    private String eventCallbackUrl;
    private String template;

    public WorkspaceCreator(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public WorkspaceCreator setEventCallbackUrl(String eventCallbackUrl) {
        this.eventCallbackUrl = eventCallbackUrl;
        return this;
    }

    public WorkspaceCreator setTemplate(String template) {
        this.template = template;
        return this;
    }

    @Override
    public Workspace execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Workspace creation failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 201) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Workspace.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.eventCallbackUrl != null) {
            request.addPostParam("EventCallbackUrl", this.eventCallbackUrl);
        }
        if (this.template != null) {
            request.addPostParam("Template", this.template);
        }
    }
}

