/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.ipmessaging.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.ipmessaging.v1.Service;

public class ServiceCreator
extends Creator<Service> {
    private final String friendlyName;

    public ServiceCreator(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @Override
    public Service execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.IPMESSAGING, "/v1/Services", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service creation failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 201) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

