/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.converter;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateConverter {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String RFC2822_DATE_TIME = "EEE, dd MMM yyyy HH:mm:ss Z";
    private static final String ISO8601_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter RFC2822_DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss Z").withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter ISO8601_DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").withZone(DateTimeZone.UTC);

    public static DateTime rfc2822DateTimeFromString(String dateTimeString) {
        try {
            return DateTime.parse((String)dateTimeString, (DateTimeFormatter)RFC2822_DATE_TIME_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DateTime iso8601DateTimeFromString(String dateTimeString) {
        try {
            return DateTime.parse((String)dateTimeString, (DateTimeFormatter)ISO8601_DATE_TIME_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LocalDate localDateFromString(String dateString) {
        try {
            return LocalDate.parse((String)dateString, (DateTimeFormatter)DATE_FORMATTER);
        }
        catch (Exception e) {
            return null;
        }
    }
}

