/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.AuthenticationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Twilio {
    public static final String VERSION = "7.0.0-rc-2";
    private static String username;
    private static String password;
    private static String accountSid;
    private static TwilioRestClient restClient;
    private static ListeningExecutorService executorService;

    private Twilio() {
    }

    public static void init(String username, String password) {
        Twilio.setUsername(username);
        Twilio.setPassword(password);
    }

    public static void init(String username, String password, String accountSid) {
        Twilio.setUsername(username);
        Twilio.setPassword(password);
        Twilio.setAccountSid(accountSid);
    }

    public static void setUsername(String username) {
        if (username == null) {
            throw new AuthenticationException("Username can not be null");
        }
        if (!username.equals(Twilio.username)) {
            Twilio.invalidate();
        }
        Twilio.username = username;
    }

    public static void setPassword(String password) {
        if (password == null) {
            throw new AuthenticationException("Password can not be null");
        }
        if (!password.equals(Twilio.password)) {
            Twilio.invalidate();
        }
        Twilio.password = password;
    }

    public static void setAccountSid(String accountSid) {
        if (accountSid == null) {
            throw new AuthenticationException("AccountSid can not be null");
        }
        if (!accountSid.equals(Twilio.accountSid)) {
            Twilio.invalidate();
        }
        Twilio.accountSid = accountSid;
    }

    public static TwilioRestClient getRestClient() {
        if (restClient == null) {
            if (username == null || password == null) {
                throw new AuthenticationException("TwilioRestClient was used before AccountSid and AuthToken were set, please call Twilio.init()");
            }
            restClient = accountSid != null ? new TwilioRestClient(username, password, accountSid) : new TwilioRestClient(username, password);
        }
        return restClient;
    }

    public static void setRestClient(TwilioRestClient restClient) {
        Twilio.restClient = restClient;
    }

    public static ListeningExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        }
        return executorService;
    }

    public static void setExecutorService(ListeningExecutorService executorService) {
        Twilio.executorService = executorService;
    }

    private static void invalidate() {
        restClient = null;
    }
}

