/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /       
 */

package com.twilio.sdk.reader.api.v2010.account.sms;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.sms.SmsMessage;

public class SmsMessageReader extends Reader<SmsMessage> {
    private final String accountSid;
    private com.twilio.sdk.type.PhoneNumber to;
    private com.twilio.sdk.type.PhoneNumber from;
    private String dateSent;

    /**
     * Construct a new SmsMessageReader.
     * 
     * @param accountSid The account_sid
     */
    public SmsMessageReader(final String accountSid) {
        this.accountSid = accountSid;
    }

    /**
     * The to.
     * 
     * @param to The to
     * @return this
     */
    public SmsMessageReader byTo(final com.twilio.sdk.type.PhoneNumber to) {
        this.to = to;
        return this;
    }

    /**
     * The from.
     * 
     * @param from The from
     * @return this
     */
    public SmsMessageReader byFrom(final com.twilio.sdk.type.PhoneNumber from) {
        this.from = from;
        return this;
    }

    /**
     * The date_sent.
     * 
     * @param dateSent The date_sent
     * @return this
     */
    public SmsMessageReader byDateSent(final String dateSent) {
        this.dateSent = dateSent;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return SmsMessage ResourceSet
     */
    @Override
    public ResourceSet<SmsMessage> execute(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage());
    }

    /**
     * Make the request to the Twilio API to perform the read.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return SmsMessage ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<SmsMessage> firstPage(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            TwilioRestClient.Domains.API,
            "/2010-04-01/Accounts/" + this.accountSid + "/SMS/Messages.json",
            client.getAccountSid()
        );
        
        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     * 
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<SmsMessage> nextPage(final Page<SmsMessage> page, 
                                     final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUri(),
            client.getAccountSid()
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of SmsMessage Resources for a given request.
     * 
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<SmsMessage> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);
        
        if (response == null) {
            throw new ApiConnectionException("SmsMessage read failed: Unable to connect to server");
        } else if (response.getStatusCode() != TwilioRestClient.HTTP_STATUS_CODE_OK) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
        
            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }
        
        return Page.fromJson(
            "sms_messages",
            response.getContent(),
            SmsMessage.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     * 
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (to != null) {
            request.addQueryParam("To", to.toString());
        }
        
        if (from != null) {
            request.addQueryParam("From", from.toString());
        }
        
        if (dateSent != null) {
            request.addQueryParam("DateSent", dateSent);
        }
        
        request.addQueryParam("PageSize", Integer.toString(getPageSize()));
    }
}