/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /       
 */

package com.twilio.sdk.fetcher.taskrouter.v1.workspace.worker;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.worker.WorkerStatistics;
import org.joda.time.DateTime;

public class WorkerStatisticsFetcher extends Fetcher<WorkerStatistics> {
    private final String workspaceSid;
    private final String workerSid;
    private Integer minutes;
    private DateTime startDate;
    private DateTime endDate;

    /**
     * Construct a new WorkerStatisticsFetcher.
     * 
     * @param workspaceSid The workspace_sid
     * @param workerSid The worker_sid
     */
    public WorkerStatisticsFetcher(final String workspaceSid, 
                                   final String workerSid) {
        this.workspaceSid = workspaceSid;
        this.workerSid = workerSid;
    }

    /**
     * The minutes.
     * 
     * @param minutes The minutes
     * @return this
     */
    public WorkerStatisticsFetcher setMinutes(final Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    /**
     * The start_date.
     * 
     * @param startDate The start_date
     * @return this
     */
    public WorkerStatisticsFetcher setStartDate(final DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    /**
     * The end_date.
     * 
     * @param endDate The end_date
     * @return this
     */
    public WorkerStatisticsFetcher setEndDate(final DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Fetched WorkerStatistics
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public WorkerStatistics execute(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            TwilioRestClient.Domains.TASKROUTER,
            "/v1/Workspaces/" + this.workspaceSid + "/Workers/" + this.workerSid + "/Statistics",
            client.getAccountSid()
        );
        
        if (minutes != null) {
            request.addQueryParam("Minutes", minutes.toString());
        }
        
        if (startDate != null) {
            request.addQueryParam("StartDate", startDate.toString());
        }
        
        if (endDate != null) {
            request.addQueryParam("EndDate", endDate.toString());
        }
        
        Response response = client.request(request);
        
        if (response == null) {
            throw new ApiConnectionException("WorkerStatistics fetch failed: Unable to connect to server");
        } else if (response.getStatusCode() != TwilioRestClient.HTTP_STATUS_CODE_OK) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
        
            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }
        
        return WorkerStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }
}