/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.twilio.twiml.Event;
import com.twilio.twiml.Method;
import com.twilio.twiml.TwiML;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="Client")
public class Client
extends TwiML {
    @XmlAttribute
    private final Method method;
    @XmlAttribute
    private final String url;
    @XmlAttribute
    private final String statusCallbackEvent;
    @XmlAttribute
    private final Method statusCallbackMethod;
    @XmlAttribute
    private final String statusCallback;
    @XmlValue
    private final String name;
    private final List<Event> statusCallbackEvents;

    private Client() {
        this(new Builder(null));
    }

    private Client(Builder b) {
        this.method = b.method;
        this.url = b.url;
        this.name = b.name;
        this.statusCallbackEvents = b.statusCallbackEvents;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.statusCallback = b.statusCallback;
        this.statusCallbackEvent = this.statusCallbackEvents != null ? Joiner.on((String)" ").join((Iterable)Lists.transform(this.statusCallbackEvents, Event.TO_STRING)) : null;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public List<Event> getStatusCallbackEvents() {
        return this.statusCallbackEvents;
    }

    public Method getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public String getStatusCallback() {
        return this.statusCallback;
    }

    public static class Builder {
        private Method method;
        private String url;
        private String name;
        private List<Event> statusCallbackEvents;
        private Method statusCallbackMethod;
        private String statusCallback;

        public Builder(String name) {
            this.name = name;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder statusCallbackEvents(List<Event> statusCallbackEvents) {
            this.statusCallbackEvents = statusCallbackEvents;
            return this;
        }

        public Builder statusCallbackMethod(Method statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Client build() {
            return new Client(this);
        }
    }
}

