/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.Workflow;
import com.twilio.sdk.updater.Updater;

public class WorkflowUpdater
extends Updater<Workflow> {
    private final String workspaceSid;
    private final String sid;
    private String friendlyName;
    private String assignmentCallbackUrl;
    private String fallbackAssignmentCallbackUrl;
    private String configuration;
    private Integer taskReservationTimeout;

    public WorkflowUpdater(String workspaceSid, String sid) {
        this.workspaceSid = workspaceSid;
        this.sid = sid;
    }

    public WorkflowUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WorkflowUpdater setAssignmentCallbackUrl(String assignmentCallbackUrl) {
        this.assignmentCallbackUrl = assignmentCallbackUrl;
        return this;
    }

    public WorkflowUpdater setFallbackAssignmentCallbackUrl(String fallbackAssignmentCallbackUrl) {
        this.fallbackAssignmentCallbackUrl = fallbackAssignmentCallbackUrl;
        return this;
    }

    public WorkflowUpdater setConfiguration(String configuration) {
        this.configuration = configuration;
        return this;
    }

    public WorkflowUpdater setTaskReservationTimeout(Integer taskReservationTimeout) {
        this.taskReservationTimeout = taskReservationTimeout;
        return this;
    }

    @Override
    public Workflow execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Workflows/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Workflow update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Workflow.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.assignmentCallbackUrl != null) {
            request.addPostParam("AssignmentCallbackUrl", this.assignmentCallbackUrl);
        }
        if (this.fallbackAssignmentCallbackUrl != null) {
            request.addPostParam("FallbackAssignmentCallbackUrl", this.fallbackAssignmentCallbackUrl);
        }
        if (this.configuration != null) {
            request.addPostParam("Configuration", this.configuration);
        }
        if (this.taskReservationTimeout != null) {
            request.addPostParam("TaskReservationTimeout", this.taskReservationTimeout.toString());
        }
    }
}

