/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.Task;
import com.twilio.sdk.updater.Updater;

public class TaskUpdater
extends Updater<Task> {
    private final String workspaceSid;
    private final String sid;
    private String attributes;
    private Task.Status assignmentStatus;
    private String reason;
    private Integer priority;

    public TaskUpdater(String workspaceSid, String sid) {
        this.workspaceSid = workspaceSid;
        this.sid = sid;
    }

    public TaskUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public TaskUpdater setAssignmentStatus(Task.Status assignmentStatus) {
        this.assignmentStatus = assignmentStatus;
        return this;
    }

    public TaskUpdater setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public TaskUpdater setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Task execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Tasks/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.assignmentStatus != null) {
            request.addPostParam("AssignmentStatus", this.assignmentStatus.toString());
        }
        if (this.reason != null) {
            request.addPostParam("Reason", this.reason);
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
    }
}

