/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.ipmessaging.v1.service;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.ipmessaging.v1.service.Role;
import com.twilio.sdk.updater.Updater;
import java.util.List;

public class RoleUpdater
extends Updater<Role> {
    private final String serviceSid;
    private final String sid;
    private final String friendlyName;
    private final List<String> permission;

    public RoleUpdater(String serviceSid, String sid, String friendlyName, List<String> permission) {
        this.serviceSid = serviceSid;
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.permission = permission;
    }

    @Override
    public Role execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.IPMESSAGING, "/v1/Services/" + this.serviceSid + "/Roles/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Role update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Role.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.permission != null) {
            for (String prop : this.permission) {
                request.addPostParam("Permission", prop.toString());
            }
        }
    }
}

