/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.api.v2010.account.queue;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.queue.Member;
import com.twilio.sdk.updater.Updater;
import java.net.URI;

public class MemberUpdater
extends Updater<Member> {
    private final String accountSid;
    private final String queueSid;
    private final String callSid;
    private final URI url;
    private final HttpMethod method;

    public MemberUpdater(String accountSid, String queueSid, String callSid, URI url, HttpMethod method) {
        this.accountSid = accountSid;
        this.queueSid = queueSid;
        this.callSid = callSid;
        this.url = url;
        this.method = method;
    }

    @Override
    public Member execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Queues/" + this.queueSid + "/Members/" + this.callSid + ".json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Member.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.url != null) {
            request.addPostParam("Url", this.url.toString());
        }
        if (this.method != null) {
            request.addPostParam("Method", this.method.toString());
        }
    }
}

