/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.taskrouter.v1.workspace.workflow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.taskrouter.v1.workspace.workflow.WorkflowStatisticsFetcher;
import com.twilio.sdk.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkflowStatistics
extends Resource {
    private static final long serialVersionUID = 164789370388563L;
    private final String accountSid;
    private final Map<String, Object> cumulative;
    private final Map<String, Object> realtime;
    private final String workflowSid;
    private final String workspaceSid;

    public static WorkflowStatisticsFetcher fetch(String workspaceSid, String workflowSid) {
        return new WorkflowStatisticsFetcher(workspaceSid, workflowSid);
    }

    public static WorkflowStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (WorkflowStatistics)objectMapper.readValue(json, WorkflowStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkflowStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (WorkflowStatistics)objectMapper.readValue(json, WorkflowStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkflowStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="cumulative") Map<String, Object> cumulative, @JsonProperty(value="realtime") Map<String, Object> realtime, @JsonProperty(value="workflow_sid") String workflowSid, @JsonProperty(value="workspace_sid") String workspaceSid) {
        this.accountSid = accountSid;
        this.cumulative = cumulative;
        this.realtime = realtime;
        this.workflowSid = workflowSid;
        this.workspaceSid = workspaceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getCumulative() {
        return this.cumulative;
    }

    public final Map<String, Object> getRealtime() {
        return this.realtime;
    }

    public final String getWorkflowSid() {
        return this.workflowSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowStatistics other = (WorkflowStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.cumulative, other.cumulative) && Objects.equals(this.realtime, other.realtime) && Objects.equals(this.workflowSid, other.workflowSid) && Objects.equals(this.workspaceSid, other.workspaceSid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.cumulative, this.realtime, this.workflowSid, this.workspaceSid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("cumulative", this.cumulative).add("realtime", this.realtime).add("workflowSid", (Object)this.workflowSid).add("workspaceSid", (Object)this.workspaceSid).toString();
    }
}

