/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.taskrouter.v1.workspace.WorkflowCreator;
import com.twilio.sdk.deleter.taskrouter.v1.workspace.WorkflowDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.taskrouter.v1.workspace.WorkflowFetcher;
import com.twilio.sdk.reader.taskrouter.v1.workspace.WorkflowReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.taskrouter.v1.workspace.WorkflowUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Workflow
extends SidResource {
    private static final long serialVersionUID = 45221576687968L;
    private final String accountSid;
    private final String assignmentCallbackUrl;
    private final String configuration;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String documentContentType;
    private final String fallbackAssignmentCallbackUrl;
    private final String friendlyName;
    private final String sid;
    private final Integer taskReservationTimeout;
    private final String workspaceSid;

    public static WorkflowFetcher fetch(String workspaceSid, String sid) {
        return new WorkflowFetcher(workspaceSid, sid);
    }

    public static WorkflowUpdater update(String workspaceSid, String sid) {
        return new WorkflowUpdater(workspaceSid, sid);
    }

    public static WorkflowDeleter delete(String workspaceSid, String sid) {
        return new WorkflowDeleter(workspaceSid, sid);
    }

    public static WorkflowReader read(String workspaceSid) {
        return new WorkflowReader(workspaceSid);
    }

    public static WorkflowCreator create(String workspaceSid, String friendlyName, String configuration, String assignmentCallbackUrl) {
        return new WorkflowCreator(workspaceSid, friendlyName, configuration, assignmentCallbackUrl);
    }

    public static Workflow fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Workflow)objectMapper.readValue(json, Workflow.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Workflow fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Workflow)objectMapper.readValue(json, Workflow.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Workflow(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assignment_callback_url") String assignmentCallbackUrl, @JsonProperty(value="configuration") String configuration, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="document_content_type") String documentContentType, @JsonProperty(value="fallback_assignment_callback_url") String fallbackAssignmentCallbackUrl, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="task_reservation_timeout") Integer taskReservationTimeout, @JsonProperty(value="workspace_sid") String workspaceSid) {
        this.accountSid = accountSid;
        this.assignmentCallbackUrl = assignmentCallbackUrl;
        this.configuration = configuration;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.documentContentType = documentContentType;
        this.fallbackAssignmentCallbackUrl = fallbackAssignmentCallbackUrl;
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.taskReservationTimeout = taskReservationTimeout;
        this.workspaceSid = workspaceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAssignmentCallbackUrl() {
        return this.assignmentCallbackUrl;
    }

    public final String getConfiguration() {
        return this.configuration;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDocumentContentType() {
        return this.documentContentType;
    }

    public final String getFallbackAssignmentCallbackUrl() {
        return this.fallbackAssignmentCallbackUrl;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final Integer getTaskReservationTimeout() {
        return this.taskReservationTimeout;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow other = (Workflow)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assignmentCallbackUrl, other.assignmentCallbackUrl) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.documentContentType, other.documentContentType) && Objects.equals(this.fallbackAssignmentCallbackUrl, other.fallbackAssignmentCallbackUrl) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.taskReservationTimeout, other.taskReservationTimeout) && Objects.equals(this.workspaceSid, other.workspaceSid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.assignmentCallbackUrl, this.configuration, this.dateCreated, this.dateUpdated, this.documentContentType, this.fallbackAssignmentCallbackUrl, this.friendlyName, this.sid, this.taskReservationTimeout, this.workspaceSid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("assignmentCallbackUrl", (Object)this.assignmentCallbackUrl).add("configuration", (Object)this.configuration).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("documentContentType", (Object)this.documentContentType).add("fallbackAssignmentCallbackUrl", (Object)this.fallbackAssignmentCallbackUrl).add("friendlyName", (Object)this.friendlyName).add("sid", (Object)this.sid).add("taskReservationTimeout", (Object)this.taskReservationTimeout).add("workspaceSid", (Object)this.workspaceSid).toString();
    }
}

