/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.preview.wireless;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.preview.wireless.RatePlanFetcher;
import com.twilio.sdk.reader.preview.wireless.RatePlanReader;
import com.twilio.sdk.resource.SidResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RatePlan
extends SidResource {
    private static final long serialVersionUID = 159290993578774L;
    private final String sid;
    private final String alias;
    private final String accountSid;
    private final String friendlyName;
    private final String dataMetering;
    private final Map<String, Object> capabilities;
    private final Integer voiceCap;
    private final Integer messagingCap;
    private final Integer commandsCap;
    private final Integer dataCap;
    private final Integer capPeriod;
    private final String capUnit;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static RatePlanReader read() {
        return new RatePlanReader();
    }

    public static RatePlanFetcher fetch(String sid) {
        return new RatePlanFetcher(sid);
    }

    public static RatePlan fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (RatePlan)objectMapper.readValue(json, RatePlan.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static RatePlan fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (RatePlan)objectMapper.readValue(json, RatePlan.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private RatePlan(@JsonProperty(value="sid") String sid, @JsonProperty(value="alias") String alias, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="data_metering") String dataMetering, @JsonProperty(value="capabilities") Map<String, Object> capabilities, @JsonProperty(value="voice_cap") Integer voiceCap, @JsonProperty(value="messaging_cap") Integer messagingCap, @JsonProperty(value="commands_cap") Integer commandsCap, @JsonProperty(value="data_cap") Integer dataCap, @JsonProperty(value="cap_period") Integer capPeriod, @JsonProperty(value="cap_unit") String capUnit, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.alias = alias;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dataMetering = dataMetering;
        this.capabilities = capabilities;
        this.voiceCap = voiceCap;
        this.messagingCap = messagingCap;
        this.commandsCap = commandsCap;
        this.dataCap = dataCap;
        this.capPeriod = capPeriod;
        this.capUnit = capUnit;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getDataMetering() {
        return this.dataMetering;
    }

    public final Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    public final Integer getVoiceCap() {
        return this.voiceCap;
    }

    public final Integer getMessagingCap() {
        return this.messagingCap;
    }

    public final Integer getCommandsCap() {
        return this.commandsCap;
    }

    public final Integer getDataCap() {
        return this.dataCap;
    }

    public final Integer getCapPeriod() {
        return this.capPeriod;
    }

    public final String getCapUnit() {
        return this.capUnit;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RatePlan other = (RatePlan)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.alias, other.alias) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dataMetering, other.dataMetering) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.voiceCap, other.voiceCap) && Objects.equals(this.messagingCap, other.messagingCap) && Objects.equals(this.commandsCap, other.commandsCap) && Objects.equals(this.dataCap, other.dataCap) && Objects.equals(this.capPeriod, other.capPeriod) && Objects.equals(this.capUnit, other.capUnit) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.alias, this.accountSid, this.friendlyName, this.dataMetering, this.capabilities, this.voiceCap, this.messagingCap, this.commandsCap, this.dataCap, this.capPeriod, this.capUnit, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("alias", (Object)this.alias).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("dataMetering", (Object)this.dataMetering).add("capabilities", this.capabilities).add("voiceCap", (Object)this.voiceCap).add("messagingCap", (Object)this.messagingCap).add("commandsCap", (Object)this.commandsCap).add("dataCap", (Object)this.dataCap).add("capPeriod", (Object)this.capPeriod).add("capUnit", (Object)this.capUnit).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

