/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.preview.wireless;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.preview.wireless.DeviceCreator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.preview.wireless.DeviceFetcher;
import com.twilio.sdk.reader.preview.wireless.DeviceReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.preview.wireless.DeviceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Device
extends SidResource {
    private static final long serialVersionUID = 71255259684453L;
    private final String sid;
    private final String alias;
    private final String accountSid;
    private final String ratePlanSid;
    private final String friendlyName;
    private final String simIdentifier;
    private final String status;
    private final URI commandsCallbackUrl;
    private final String commandsCallbackMethod;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static DeviceFetcher fetch(String sid) {
        return new DeviceFetcher(sid);
    }

    public static DeviceReader read() {
        return new DeviceReader();
    }

    public static DeviceCreator create(String ratePlan) {
        return new DeviceCreator(ratePlan);
    }

    public static DeviceUpdater update(String sid) {
        return new DeviceUpdater(sid);
    }

    public static Device fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Device)objectMapper.readValue(json, Device.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Device fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Device)objectMapper.readValue(json, Device.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Device(@JsonProperty(value="sid") String sid, @JsonProperty(value="alias") String alias, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="rate_plan_sid") String ratePlanSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sim_identifier") String simIdentifier, @JsonProperty(value="status") String status, @JsonProperty(value="commands_callback_url") URI commandsCallbackUrl, @JsonProperty(value="commands_callback_method") String commandsCallbackMethod, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.alias = alias;
        this.accountSid = accountSid;
        this.ratePlanSid = ratePlanSid;
        this.friendlyName = friendlyName;
        this.simIdentifier = simIdentifier;
        this.status = status;
        this.commandsCallbackUrl = commandsCallbackUrl;
        this.commandsCallbackMethod = commandsCallbackMethod;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRatePlanSid() {
        return this.ratePlanSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSimIdentifier() {
        return this.simIdentifier;
    }

    public final String getStatus() {
        return this.status;
    }

    public final URI getCommandsCallbackUrl() {
        return this.commandsCallbackUrl;
    }

    public final String getCommandsCallbackMethod() {
        return this.commandsCallbackMethod;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device other = (Device)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.alias, other.alias) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.ratePlanSid, other.ratePlanSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.simIdentifier, other.simIdentifier) && Objects.equals(this.status, other.status) && Objects.equals(this.commandsCallbackUrl, other.commandsCallbackUrl) && Objects.equals(this.commandsCallbackMethod, other.commandsCallbackMethod) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.alias, this.accountSid, this.ratePlanSid, this.friendlyName, this.simIdentifier, this.status, this.commandsCallbackUrl, this.commandsCallbackMethod, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("alias", (Object)this.alias).add("accountSid", (Object)this.accountSid).add("ratePlanSid", (Object)this.ratePlanSid).add("friendlyName", (Object)this.friendlyName).add("simIdentifier", (Object)this.simIdentifier).add("status", (Object)this.status).add("commandsCallbackUrl", (Object)this.commandsCallbackUrl).add("commandsCallbackMethod", (Object)this.commandsCallbackMethod).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

