/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.monitor.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.monitor.v1.EventFetcher;
import com.twilio.sdk.reader.monitor.v1.EventReader;
import com.twilio.sdk.resource.SidResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Event
extends SidResource {
    private static final long serialVersionUID = 47454553486237L;
    private final String accountSid;
    private final String actorSid;
    private final String actorType;
    private final String description;
    private final Map<String, Object> eventData;
    private final DateTime eventDate;
    private final String eventType;
    private final String resourceSid;
    private final String resourceType;
    private final String sid;
    private final String source;
    private final String sourceIpAddress;

    public static EventFetcher fetch(String sid) {
        return new EventFetcher(sid);
    }

    public static EventReader read() {
        return new EventReader();
    }

    public static Event fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Event)objectMapper.readValue(json, Event.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Event fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Event)objectMapper.readValue(json, Event.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Event(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="actor_sid") String actorSid, @JsonProperty(value="actor_type") String actorType, @JsonProperty(value="description") String description, @JsonProperty(value="event_data") Map<String, Object> eventData, @JsonProperty(value="event_date") String eventDate, @JsonProperty(value="event_type") String eventType, @JsonProperty(value="resource_sid") String resourceSid, @JsonProperty(value="resource_type") String resourceType, @JsonProperty(value="sid") String sid, @JsonProperty(value="source") String source, @JsonProperty(value="source_ip_address") String sourceIpAddress) {
        this.accountSid = accountSid;
        this.actorSid = actorSid;
        this.actorType = actorType;
        this.description = description;
        this.eventData = eventData;
        this.eventDate = DateConverter.iso8601DateTimeFromString(eventDate);
        this.eventType = eventType;
        this.resourceSid = resourceSid;
        this.resourceType = resourceType;
        this.sid = sid;
        this.source = source;
        this.sourceIpAddress = sourceIpAddress;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getActorSid() {
        return this.actorSid;
    }

    public final String getActorType() {
        return this.actorType;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Map<String, Object> getEventData() {
        return this.eventData;
    }

    public final DateTime getEventDate() {
        return this.eventDate;
    }

    public final String getEventType() {
        return this.eventType;
    }

    public final String getResourceSid() {
        return this.resourceSid;
    }

    public final String getResourceType() {
        return this.resourceType;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getSource() {
        return this.source;
    }

    public final String getSourceIpAddress() {
        return this.sourceIpAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event other = (Event)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.actorSid, other.actorSid) && Objects.equals(this.actorType, other.actorType) && Objects.equals(this.description, other.description) && Objects.equals(this.eventData, other.eventData) && Objects.equals(this.eventDate, other.eventDate) && Objects.equals(this.eventType, other.eventType) && Objects.equals(this.resourceSid, other.resourceSid) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.sid, other.sid) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceIpAddress, other.sourceIpAddress);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.actorSid, this.actorType, this.description, this.eventData, this.eventDate, this.eventType, this.resourceSid, this.resourceType, this.sid, this.source, this.sourceIpAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("actorSid", (Object)this.actorSid).add("actorType", (Object)this.actorType).add("description", (Object)this.description).add("eventData", this.eventData).add("eventDate", (Object)this.eventDate).add("eventType", (Object)this.eventType).add("resourceSid", (Object)this.resourceSid).add("resourceType", (Object)this.resourceType).add("sid", (Object)this.sid).add("source", (Object)this.source).add("sourceIpAddress", (Object)this.sourceIpAddress).toString();
    }
}

